// PWM code
//http://www.lpcware.com/content/forum/problem-using-pwm-on-landtiger-lpc1768-for-servo-control

#include "mbed.h"



InterruptIn event1(p15);
InterruptIn event2(p16);
InterruptIn event3(p17);
//int duty;
//int mr0;    //ställer perioden
int Frequency=700;
int dutycycle=0;    //%
int duty;
int stepdown=0;

void dutyC(int dutyy, int pin) //dutyy is the input dutycycle, input in "pin" which PWM pin that one wants to change.
{   

    int mr00=(96000000)/Frequency;
     
    LPC_PWM1->TCR = (1<<1)|(1<<0);

    LPC_PWM1->MR0 = 0; 
    LPC_PWM1->TCR = (0<<1); 
    LPC_PWM1->MR0 = mr00; 
   
    if (pin==1){LPC_PWM1->MR1 = mr00*dutyy/100;}
    else if (pin==2){LPC_PWM1->MR2 = mr00*dutyy/100;}
      
    LPC_PWM1->LER = (1 << 0) | (1 << 1) ; //Apply changes
    LPC_PWM1->TCR = (1<<0)|(1<<3);
}

void trigger1() 
{
    dutyC(100,1);
    dutyC(100,2);

    wait_ms(100);


    dutyC(0,1);
    dutyC(0,2);
   // event.disable_irq();    
      
    wait(3);
    dutyC(100,2); // PWM on p21
    //duty=100;
    wait_ms(30);
    stepdown=1;
    /*duty=100;
    while(duty>=0)
    {
        dutyC(duty,1);
        wait_us(5 000);
        duty=duty-1;
    }
    */
        //dutyC(100,1);
    //wait_ms(50);
    //dutyC(0,2); // PWM on p21
    //wait_ms(15);
    //event.enable_irq();
    //wait_ms(10); // wait_us(int us)

}

void trigger2() 
{
    dutyC(100,1);
    dutyC(100,2);

    wait_ms(100);


    dutyC(0,1);
    dutyC(0,2);
   // event.disable_irq();    
      
    wait(3);
    dutyC(100,1); // PWM on p21
    
    wait_ms(30);
    
    //duty=100;
    stepdown=0;
    
    //wait_ms(15);
    //wait_ms(50);
    //dutyC(0,2); // PWM on p21
    //event.enable_irq();
    //wait_ms(10); // wait_us(int us)
}


/*void trigger3() 
{
    dutyC(50,1);
    
    while(duty<=50)
    {
        dutyC(duty);
        wait_ms(5);
        duty=duty+1;
    }

}*/
int main(void)
{
    wait(1);
    event1.fall(&trigger1); // fall
    event2.fall(&trigger2); // fall
    //event3.fall(&trigger3); // fall

    LPC_SC->PCONP |= 1 << 6; // enable power for PWM1 
    
    int prescaler=1;
    LPC_SC->PCLKSEL0 |= prescaler << 12 ; //PCLK = CCLK = 96MHz
    // Prescalers: 0 cclk/4, 1 cclk/1, 2 cclk/2, 3 cclk/8
       
    LPC_PWM1->TCR = 0x00;             //Timer control reg
    LPC_PWM1->CTCR = 0x00;            //Count control reg
    LPC_PWM1->MCR = 0x00;             //Match control
    LPC_PWM1->CCR = 0x00;             //Capture control 
    LPC_PWM1->PCR = 0x00;             //PWM control reg
    LPC_PWM1->LER = 0x00;             //Load enable reg
    LPC_PWM1->PR = 1 - 1;             //Prescale
    
    LPC_PINCON->PINSEL4 = (1<<0) |(1<<2); //output to pin 2.0, 2.1
    LPC_PINCON->PINMODE4 = (2<<0)|(2<<2);
    
        
    //int Frequency=10; //Hz
    

    int mr0=(96000000/prescaler)/Frequency;
    
    LPC_PWM1->MR0 = mr0;  /*set clock cycles for PWM. PWM freq = PCLK/MR0 (?)*/
    LPC_PWM1->MR1 = mr0*dutycycle/100; // pulse width 1.5ms
    LPC_PWM1->MR2 = 0; // pulse width 1.5ms
    
    LPC_PWM1->LER = (1 << 0) | (1 << 1) ; //Apply changes
    LPC_PWM1->MCR |= (1 << 1) ; // interrupt on match0.Reset timer on Match0;
    LPC_PWM1->PCR = (1<<9)|(1<<10); //--- PWM1 output
    LPC_PWM1->TCR = (1<<0)|(1<<3);

    while(1)
    {
    
        if (stepdown==1)
        {
            duty=100;
            while(duty>=0)
            {
                if(stepdown!=1)
                {
                    break;
                }
                dutyC(duty,1);
                wait_us(300);
                duty=duty-1;
            }
            stepdown=0;
        }
    }
}