/* Copyright (C) 2020 Arrow Electronics */

#ifndef _TMP06_H_
#define _TMP06_H_

#include "mbed.h"

#define SUCCESS 0
#define FAILURE 1
#define SEM_TIMEOUT_MS 250 

class TMP06 {
    public:
        TMP06(PinName pin);
        ~TMP06();
        int read(float *temperature);

    private:
        void on_rise();
        void on_fall();
        
        InterruptIn _pwm_pin;
        Timer _timer1;
        Timer _timer2;
        Semaphore _semaphore;
        bool _first_run;
        bool _started;
};

#endif /* _TMP06_H_ */