/* Copyright (C) 2020 Arrow Electronics */

#include "TMP06.h"

TMP06::TMP06(PinName pin) : _pwm_pin(pin), _semaphore(0, 1)
{

}

TMP06::~TMP06() 
{
    
}

int TMP06::read(float *temperature)
{
    _pwm_pin.disable_irq();
    _first_run = true; // blocker for "rise"
    _started = false;  // blocker for "fall"
    _timer1.reset();
    _timer2.reset();
    _pwm_pin.rise(callback(this, &TMP06::on_rise));
    _pwm_pin.fall(callback(this, &TMP06::on_fall));
    _pwm_pin.enable_irq();

    // 250 - period of sensor should be around 100, 
    // more would means there is some kind of issue
    if (_semaphore.try_acquire_for(SEM_TIMEOUT_MS)) {
        // based on TMP05/TMP06 datasheet rev. C
        *temperature = (421 - 751 * ((float)_timer1.read_us() / (float)_timer2.read_us()));
        return SUCCESS;
    }
    else {
        return FAILURE;
    }
}

void TMP06::on_rise()
{
    if (_first_run) {
        _timer1.start();
        _first_run = false;
        _started = true;
    }
    else {
        _timer2.stop();
        _semaphore.release();
        _pwm_pin.disable_irq();
    }
}

void TMP06::on_fall()
{
    if (_started) {
        _timer1.stop();
        _timer2.start();
        _started = false;
    }
}
