#ifndef FXPQ3115_H_
#define FXPQ3115_H_

#include "mbed.h"
#include "FXPQ3115_reg.h"

#ifndef SUCCESS
#define SUCCESS 0
#endif

#ifndef FAILURE
#define FAILURE 1
#endif

#ifdef FXPQ3115_I2C_ADDRESS
#define FXPQ3115_I2C_ADDRESS_SHIFTED (FXPQ3115_I2C_ADDRESS << 1)
#endif

#define FXPQ3115_PRESSURE_CONV_FACTOR (64)     /* Will give Pascals */
#define FXPQ3115_ALTITUDE_CONV_FACTOR (65536)  /* Will give meters above MSL */
#define FXPQ3115_TEMPERATURE_CONV_FACTOR (256) /* Will give °C */

class FXPQ3115 {
    public:
        FXPQ3115(PinName sda, PinName scl);

        uint8_t sensor_init();
        uint8_t read_oneshotMode_bar();
        uint32_t print_pressure();

    private:
        I2C _i2c;
        char _bar_data[3];

        uint8_t _config_bar();
        uint8_t _wait_for_acq();
};

#endif // FXPQ3115_H_
