#include "FXPQ3115.h"
#include "mbed.h"

FXPQ3115::FXPQ3115(PinName sda, PinName scl) : _i2c(sda, scl)
{

}

uint8_t FXPQ3115::sensor_init()
{
    char write_value = FXPQ3115_WHO_AM_I;
    char read_value;
    if (SUCCESS != _i2c.write(FXPQ3115_I2C_ADDRESS_SHIFTED, 
                   &write_value, sizeof(write_value), true)) {
        return FAILURE;
    }
    if (SUCCESS != _i2c.read(FXPQ3115_I2C_ADDRESS_SHIFTED, &read_value, 
                   sizeof(read_value))) {
        return FAILURE;
    }
    if (read_value != FXPQ3115_WHOAMI_VALUE) {
        return FAILURE;
    } 
    return SUCCESS;
}

uint8_t FXPQ3115::read_oneshotMode_bar()
{
    uint8_t status;
    if (_config_bar() != SUCCESS) {
        return FAILURE;
    }

    if (_wait_for_acq() != SUCCESS) {
        return FAILURE;
    }

    char bar_data_write = FXPQ3115_OUT_P_MSB;
    status  = _i2c.write(FXPQ3115_I2C_ADDRESS_SHIFTED, &bar_data_write, 
                         sizeof(bar_data_write), true);
    status |= _i2c.read(FXPQ3115_I2C_ADDRESS_SHIFTED, _bar_data, sizeof(_bar_data));

    if (status != SUCCESS) {
        return FAILURE;
    }
    
    return SUCCESS;
}

uint32_t FXPQ3115::print_pressure()
{
    uint32_t pressure = (_bar_data[0] << 16) | (_bar_data[1] << 8) | _bar_data[2];
    return pressure / FXPQ3115_PRESSURE_CONV_FACTOR;
}

uint8_t FXPQ3115::_config_bar() 
{
    char bar_config[] = {FXPQ3115_CTRL_REG1, FXPQ3115_CTRL_REG1_ALT_BAR};
    if (SUCCESS != _i2c.write(FXPQ3115_I2C_ADDRESS_SHIFTED, bar_config, 2, true)) {
        return FAILURE;
    }
    return SUCCESS;
}

uint8_t FXPQ3115::_wait_for_acq()
{
    uint8_t status;
    char dataReady;
    char set_ost[] = {FXPQ3115_CTRL_REG1, FXPQ3115_CTRL_REG1_OST_SET};
    if (SUCCESS != _i2c.write(FXPQ3115_I2C_ADDRESS_SHIFTED, set_ost, sizeof(set_ost))) {
        return FAILURE;
    }
    
    do
    {
        char get_ost = FXPQ3115_CTRL_REG1;
        status = _i2c.write(FXPQ3115_I2C_ADDRESS_SHIFTED, &get_ost, 1, true);
        status |= _i2c.read(FXPQ3115_I2C_ADDRESS_SHIFTED, &dataReady, 1);
        if (status != SUCCESS) {
            return FAILURE;
        }
    } /* Loop until sample acquisition is not completed */
    while (0 != (dataReady & FXPQ3115_CTRL_REG1_OST_MASK));

    return SUCCESS;
}
