/**
 * @file    flash_blob.c
 * @brief   Flash algorithm for the Musca A
 *
 * DAPLink Interface Firmware
 * Copyright (c) 2016-2019, ARM Limited, All Rights Reserved
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flash_blob.h"

static const uint32_t flash_prog_blob[] = {
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x4604b570, 0x4616460d, 0x4448486a, 0xb9e86800, 0x44784869, 0x44494969, 0x46086008, 0x44494968,
    0x46086008, 0x44494967, 0x68096008, 0xf0006808, 0x4964fc9c, 0x68084449, 0xf0002101, 0xb108f9c1,
    0xbd702001, 0x495b2001, 0x60084449, 0xe7f82000, 0x4604b510, 0x4857b984, 0x68004448, 0xd10b2801,
    0x44494958, 0xf0006808, 0xb108fa25, 0xbd102001, 0x49502000, 0x60084449, 0xe7f82000, 0x4951b510,
    0x22004449, 0x46116808, 0xfbaaf000, 0x2001b108, 0x2000bd10, 0xb510e7fc, 0xf0244604, 0xf5a0407f,
    0x49481400, 0xf44f4449, 0x68083280, 0xf0004621, 0xb108fb97, 0xbd102001, 0xe7fc2000, 0x41f0e92d,
    0x460d4604, 0xf0244617, 0xf5a0407f, 0x493d1400, 0x462b4449, 0x6808463a, 0xf0004621, 0x4606faf6,
    0x4630b116, 0x81f0e8bd, 0xe7fb2000, 0x43f8e92d, 0x46884607, 0xf0274615, 0xf5a6467f, 0x24001600,
    0x4930e025, 0x23044449, 0x6808466a, 0xf0004631, 0xf89dfa8e, 0x5d290000, 0xd1114288, 0x1001f89d,
    0x5c281c60, 0xd10b4281, 0x1002f89d, 0x5c281ca0, 0xd1054281, 0x1003f89d, 0x5c281ce0, 0xd0044281,
    0x1000f506, 0xe8bd4420, 0x1d3683f8, 0x45441d24, 0x2000d3d7, 0xe92de7f7, 0x460643f8, 0x4614460f,
    0x457ff026, 0x1500f5a5, 0x0800f04f, 0x4915e01d, 0x23044449, 0x6808466a, 0xf0004629, 0xf89dfa58,
    0x42a00000, 0xf89dd10b, 0x42a00001, 0xf89dd107, 0x42a00002, 0xf89dd103, 0x42a00003, 0x2001d002,
    0x83f8e8bd, 0xf1081d2d, 0x45b80804, 0x2000d3df, 0x0000e7f6, 0x00000004, 0x00000da6, 0x00000008,
    0x0000000c, 0x00000020, 0xb118b570, 0x2d2018d5, 0xb902d800, 0x2a20bd70, 0x6001d101, 0x2501e7fa,
    0x1e6c4095, 0xfa046805, 0x43b5f603, 0x0604ea01, 0x4335409e, 0xbf006005, 0xb510e7ec, 0x21064604,
    0xf0006820, 0xbd10fd7b, 0x4604b57f, 0x2000460d, 0x90009003, 0x90029001, 0xaa032301, 0x68202165,
    0xfd7ef000, 0xb1164606, 0xb0044630, 0xb125bd70, 0xd00d2d01, 0xd1212d02, 0xf89de015, 0xf040000c,
    0x90030040, 0x000cf89d, 0x0080f040, 0xe0179003, 0x000cf89d, 0x0040f020, 0xf89d9003, 0xf040000c,
    0x90030080, 0xf89de00c, 0xf040000c, 0x90030040, 0x000cf89d, 0x0080f020, 0xe0019003, 0xe7d42001,
    0x4620bf00, 0xffb9f7ff, 0x90002000, 0x90029001, 0xaa032301, 0x68202161, 0xfd5ff000, 0xb10e4606,
    0xe7c24630, 0x462a462b, 0x68204629, 0xfb83f000, 0xb10e4606, 0xe7b84630, 0xe7b62000, 0x4604b57f,
    0x2000460e, 0x90009003, 0x90029001, 0xaa032301, 0x68202185, 0xfd24f000, 0xb1154605, 0xb0044628,
    0x2304bd70, 0x4631461a, 0xf7ffa803, 0x4620ff6d, 0xff83f7ff, 0x90002000, 0x90029001, 0xaa032301,
    0x68202181, 0xfd29f000, 0xb10d4605, 0xe7e64628, 0xe7e42000, 0x4605b57f, 0x90032000, 0x2000e00e,
    0x90019000, 0x23019002, 0x2170aa03, 0xf0006828, 0x4604fcf7, 0x4620b114, 0xbd70b004, 0x000cf89d,
    0x280009c0, 0x2000d0eb, 0xe92de7f6, 0xb0844dff, 0x46924606, 0x9c10469b, 0xf5c0b2e0, 0xe9dd7580,
    0xe9cd1011, 0x90024100, 0x4652462b, 0x99056830, 0xfcf3f000, 0xb11f4607, 0xb0084638, 0x8df0e8bd,
    0x442c44aa, 0xf7ff4630, 0x4680ffc5, 0x0f00f1b8, 0x4640d001, 0x4630e7f1, 0xff2ff7ff, 0x1011e9dd,
    0x0305ebab, 0x4100e9cd, 0x46529002, 0x99056830, 0xfcd3f000, 0xb10f4607, 0xe7de4638, 0xe7dc2000,
    0x4df3e92d, 0x4604b082, 0xb1209803, 0xd00b2801, 0xd11b2802, 0x2700e011, 0x0a03f04f, 0xf04f2600,
    0x20000b02, 0xe0159001, 0xf04f2700, 0x26080a0b, 0x0b02f04f, 0x90012000, 0x2702e00c, 0x0a6bf04f,
    0xf04f2608, 0x20000b32, 0xe0039001, 0xb0042001, 0x8df0e8bd, 0x4639bf00, 0xf7ff4620, 0x4680fef5,
    0x0f00f1b8, 0x4640d001, 0x4631e7f1, 0xf7ff4620, 0x4680ff45, 0x0f00f1b8, 0x4640d001, 0xbf00e7e7,
    0xf0006820, 0x2800fa40, 0x6820d0fa, 0xfa85f000, 0x682068a1, 0xfa91f000, 0xb10d4605, 0xe7d64628,
    0x46514632, 0xf0006820, 0x4605faff, 0x4628b10d, 0x6820e7cd, 0x9a014659, 0xfb01f000, 0xb10d4605,
    0xe7c44628, 0x7180f44f, 0xf0006820, 0x4605fb03, 0x4628b10d, 0x2103e7bb, 0xf0006820, 0x4605fb14,
    0x4628b10d, 0x6820e7b3, 0xfa5ff000, 0x74209803, 0xe7ac2000, 0x4604b570, 0x46202100, 0xfea4f7ff,
    0xb10d4605, 0xbd704628, 0x46202100, 0xfef6f7ff, 0xb10d4605, 0xe7f64628, 0x6820bf00, 0xf9f3f000,
    0xd0fa2800, 0xf0006820, 0x6820fa38, 0xfb30f000, 0xf0006820, 0x2000fa3a, 0xbf007420, 0xe92de7e3,
    0x46044df0, 0x46174688, 0x6820461d, 0x68406800, 0xfbb51c46, 0xb107fbf6, 0x2001b915, 0x8df0e8bd,
    0x0005eb08, 0x428868e1, 0x2006d301, 0xf04fe7f6, 0xe00d0a00, 0x68204641, 0xfadef000, 0x46384632,
    0xf0006861, 0x1badfc29, 0x44b04437, 0x0a01f10a, 0xd3ef45da, 0x4641b145, 0xf0006820, 0x462afacd,
    0x68614638, 0xfc18f000, 0xf0006820, 0x2000fadc, 0xe92de7d4, 0x46044dfc, 0x4692460f, 0x6820461e,
    0x68406800, 0x0801f100, 0x0f00f1ba, 0xb916d000, 0xe8bd2001, 0x19b88dfc, 0x428868e1, 0x2006d301,
    0xf007e7f7, 0x1b7f0503, 0xfbb01970, 0x9001f0f8, 0x90002000, 0x4639e01e, 0xf0006820, 0xeba8fa9d,
    0x68610205, 0x46511948, 0xfbe6f000, 0x0005eba8, 0xeba81a36, 0x44820005, 0x25004447, 0xf7ff4620,
    0x4683fe99, 0x0f00f1bb, 0x4658d001, 0x9800e7d1, 0x90001c40, 0x0100e9dd, 0xd3dc4288, 0x4639b196,
    0xf0006820, 0x6861fa79, 0x46321948, 0xf0004651, 0x4620fbc3, 0xfe7ef7ff, 0xf1bb4683, 0xd0010f00,
    0xe7b64658, 0xf0006820, 0x2000fa7e, 0xe92de7b1, 0xb0844dff, 0x460e4605, 0x08f8461f, 0x7c289003,
    0x2801b160, 0x2802d005, 0xf04fd107, 0x24080a6b, 0xf04fe008, 0x24080a0b, 0xbf00e004, 0x0a03f04f,
    0xbf002400, 0xf04fbf00, 0xe0180b00, 0xe9cd2003, 0x94026000, 0x68282308, 0x9a064651, 0xfb50f000,
    0xf1b84680, 0xd0030f00, 0xb0084640, 0x8df0e8bd, 0x30089806, 0x36089006, 0xf10b3f08, 0x98030b01,
    0xd3e34583, 0x2003b17f, 0x6000e9cd, 0x463b9402, 0x46516828, 0xf0009a06, 0x4680fb33, 0x0f00f1b8,
    0x4640d001, 0x2000e7e1, 0xe92de7df, 0xb0864dff, 0x460c4680, 0x08f0461e, 0xf8989005, 0xb1480010,
    0xd0062801, 0xd1032802, 0x0b32f04f, 0xe0052500, 0xbf00bf00, 0x0b02f04f, 0xbf002500, 0x2000bf00,
    0xe0379004, 0xf7ff4640, 0x0a21fd78, 0xebb11de0, 0xd00f2f10, 0x23082003, 0x0501e9cd, 0x46599400,
    0x9a084640, 0xfe11f7ff, 0xb1a74607, 0xb00a4638, 0x8df0e8bd, 0xe9cd2003, 0x94000501, 0xf8d82308,
    0x46590000, 0xf0009a08, 0x4682fb08, 0x0f00f1ba, 0x4650d001, 0x4640e7eb, 0xfddcf7ff, 0xb10f4607,
    0xe7e44638, 0x30089808, 0x34089008, 0x98043e08, 0x90041c40, 0x0104e9dd, 0xd3c34288, 0x4640b376,
    0xfd3bf7ff, 0x19a00a21, 0xebb11e40, 0xd00d2f10, 0x46332003, 0x0501e9cd, 0x46599400, 0x9a084640,
    0xfdd3f7ff, 0xb1974607, 0xe7c04638, 0xe9cd2003, 0x94000501, 0xf8d84633, 0x46590000, 0xf0009a08,
    0x4682facc, 0x0f00f1ba, 0x4650d001, 0x4640e7af, 0xfda0f7ff, 0xb10f4607, 0xe7a84638, 0xe7a62000,
    0x4df0e92d, 0x4607b086, 0x4693460c, 0xf7ff4638, 0xf1bbfd04, 0xd0090f00, 0x5f80f5bb, 0xf5bbd01d,
    0xd0124f00, 0x3f80f5bb, 0xe007d11f, 0x2005b11c, 0xe8bdb006, 0x25c78df0, 0xe0182600, 0x260325d8,
    0xb108b2a0, 0xe7f32005, 0x2552e011, 0xf3c42603, 0xb108000e, 0xe7eb2005, 0x2520e009, 0xf3c42603,
    0xb108000b, 0xe7e32005, 0x2001e001, 0xbf00e7e0, 0x42a068f8, 0x2006d801, 0x2000e7da, 0xc151a901,
    0x90009004, 0x461a2300, 0x68384629, 0xf986f000, 0xf1b84680, 0xd0010f00, 0xe7c94640, 0xf7ff4638,
    0x4682fd49, 0x0f00f1ba, 0x4640d001, 0x2000e7c0, 0x0000e7be, 0xb118b570, 0x2d2018d5, 0xb902d800,
    0x2a20bd70, 0x6001d101, 0x2501e7fa, 0x1e6c4095, 0xfa046805, 0x43b5f603, 0x0604ea01, 0x4335409e,
    0xbf006005, 0x4601e7ec, 0x68026808, 0x0fc06810, 0xe92d4770, 0x460545f8, 0x4614468a, 0x6828461e,
    0xb10e6807, 0xe0011d38, 0x0008f107, 0xf8d84680, 0x90000000, 0x4628bf00, 0xffe5f7ff, 0xd0fa2800,
    0xd9022c1f, 0xe8bd2001, 0x230085f8, 0x46512208, 0xf7ff4668, 0x2318ffbf, 0x46212205, 0xf7ff4668,
    0x9800ffb9, 0x0000f8c8, 0xe7ec2000, 0xb1214601, 0xd0042901, 0xd1062902, 0x2000e003, 0x20014770,
    0x2002e7fc, 0xf04fe7fa, 0xe7f730ff, 0x68084601, 0x68106802, 0x0001f000, 0x46014770, 0x6810680a,
    0xf0226802, 0x60020201, 0x46014770, 0x6810680a, 0xf0426802, 0x60020201, 0xb5704770, 0x460c4605,
    0x68066828, 0x4628bf00, 0xff9df7ff, 0xd0fa2800, 0x0001f004, 0x2c02b918, 0x2c20d301, 0x2001d901,
    0x2001bd70, 0x0154ebc0, 0x22042313, 0xf7ff4630, 0x2000ff71, 0xe92de7f4, 0xb0824dff, 0x460f4682,
    0xf8da4693, 0x68040000, 0x90016860, 0x900068a0, 0x4650bf00, 0xff77f7ff, 0xd0fa2800, 0xf7ff4638,
    0x4605ffa5, 0xb9181c68, 0xb0062001, 0x8df0e8bd, 0x2308b13f, 0x46292202, 0xf7ff1d20, 0x2000ff4b,
    0x4658e7f3, 0xff92f7ff, 0x98054680, 0xff8ef7ff, 0xf1084606, 0xb1080001, 0xb9081c70, 0xe7e42001,
    0x22022308, 0xa8014629, 0xff34f7ff, 0x2202230c, 0xa8014641, 0xff2ef7ff, 0x22022310, 0xa8014631,
    0xff28f7ff, 0x2202230c, 0x46684641, 0xff22f7ff, 0x22022310, 0x46684631, 0xff1cf7ff, 0x60609801,
    0x60a09800, 0xe7c02000, 0x4604b570, 0x4616460d, 0x46322301, 0x46204629, 0xff2bf7ff, 0xb570bd70,
    0x460d4604, 0x23004616, 0x46294632, 0xf7ff4620, 0xbd70ff20, 0x4604b570, 0x6820460d, 0xbf006806,
    0xf7ff4620, 0x2800ff10, 0xf5b5d0fa, 0xd3015f80, 0xbd702001, 0x220c2304, 0xf1064629, 0xf7ff0014,
    0x2000fee9, 0xb570e7f5, 0x460c4605, 0x68066828, 0x4628bf00, 0xfef7f7ff, 0xd0fa2800, 0x2c10b10c,
    0x2001d901, 0x1e61bd70, 0x22042300, 0x0014f106, 0xfed0f7ff, 0xe7f52000, 0x4604b570, 0x6820460d,
    0x46206803, 0xff22f7ff, 0xb1164606, 0xf7ff4620, 0x625dff24, 0xf4406818, 0x60183080, 0x4620b116,
    0xff23f7ff, 0xb530bd70, 0x68184603, 0x46186804, 0xff0cf7ff, 0xb1154605, 0xf7ff4618, 0x6820ff0e,
    0x3080f420, 0xb1156020, 0xf7ff4618, 0xbd30ff0e, 0x680a4601, 0x4a8e6810, 0x22036002, 0x22026042,
    0x4a8c6082, 0x22006142, 0xf8c06242, 0xf8c02090, 0xf8c02094, 0xf8c020a8, 0x477020ac, 0x4dffe92d,
    0x4616b086, 0xf8dd461d, 0xe9dda054, 0x98068712, 0x68046800, 0x90052000, 0xb10db116, 0xe0002001,
    0x46832000, 0x0f00f1b8, 0xb10fd002, 0xe0002001, 0x90042000, 0x0f00f1ba, 0x2001d001, 0x2000e000,
    0x20009003, 0x90029001, 0xd9032d08, 0xb00a2001, 0x8df0e8bd, 0xd9012f08, 0xe7f82001, 0x0f04f1ba,
    0x2001d901, 0x9816e7f3, 0xd901281f, 0xe7ee2001, 0x0f00f1bb, 0x9804d003, 0x2001b108, 0x2318e7e7,
    0xa8052208, 0xf7ff9907, 0xf1bbfe45, 0xd0090f00, 0xf4409805, 0x90050000, 0x23141e69, 0xa8052203,
    0xfe38f7ff, 0xb3289804, 0xf4409805, 0x90054000, 0x230c1e79, 0xa8052203, 0xfe2cf7ff, 0x0003f008,
    0xf007b968, 0xb9500003, 0x0000f8d8, 0x00a8f8c4, 0xd10f2f08, 0x0004f8d8, 0x00acf8c4, 0x463ae00a,
    0xa8014641, 0xf898f000, 0xf8c49801, 0x980200a8, 0x00acf8c4, 0xb1689803, 0xf4409805, 0x90052000,
    0xf8c49814, 0xf1aa0094, 0x23100101, 0xa8052202, 0xfe00f7ff, 0x22052307, 0x9916a805, 0xfdfaf7ff,
    0xf8449805, 0x68200f90, 0x0001f040, 0x0990f844, 0xf8d4bf00, 0xf3c00090, 0x28000040, 0xf1bbd1f9,
    0xd0190f00, 0x0003f006, 0xf005b958, 0xb9400003, 0x00a0f8d4, 0x2d086030, 0xf8d4d10e, 0x607000a4,
    0xf8d4e00a, 0x900100a0, 0x00a4f8d4, 0x462a9002, 0x4630a901, 0xf850f000, 0xe7682000, 0xb085b530,
    0x460d4604, 0x90012000, 0x90039002, 0x46039004, 0x46294602, 0x46209000, 0xff30f7ff, 0xbd30b005,
    0x4df0e92d, 0x4606b086, 0x4614460f, 0xe9dd461d, 0xf8ddab0f, 0xb1048038, 0x2001b91d, 0xe8bdb006,
    0x20008df0, 0xe8a1a901, 0x462b0d01, 0x46394622, 0x46309000, 0xff12f7ff, 0xe92de7f0, 0xb0864df0,
    0x460f4606, 0x461d4614, 0xab0fe9dd, 0x8038f8dd, 0xb91db104, 0xb0062001, 0x8df0e8bd, 0x461a2300,
    0x46304639, 0x0d30e88d, 0xfef8f7ff, 0x0000e7f3, 0x80780081, 0x00101002, 0x0301ea40, 0xd003079b,
    0xc908e009, 0xc0081f12, 0xd2fa2a04, 0xf811e003, 0xf8003b01, 0x1e523b01, 0x4770d2f9, 0x5010a000,
    0x0003ffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00000004, 0x00800000,
    0x00000000, 0x00000000
};

// Start address of flash
static const uint32_t flash_start = 0x00200000;
// Size of flash
static const uint32_t flash_size = 0x00800000;

/**
* List of start and size for each size of flash sector
* The size will apply to all sectors between the listed address and the next address
* in the list.
* The last pair in the list will have sectors starting at that address and ending
* at address start + size.
*/
static const sector_info_t sectors_info[] = {
    {0x00200000, 0x00010000},
};

static const program_target_t flash = {
    0x20000021, // Init
    0x20000071, // UnInit
    0x2000009d, // EraseChip
    0x200000b7, // EraseSector
    0x200000dd, // ProgramPage
    0x2000010d, // Verify

    // BKPT : start of blob + 1
    // RSB  : blob start + header + rw data offset
    // RSP  : stack pointer
    {
        0x20000001,
        0x20000de4,
        0x20001100
    },

    0x20000000 + 0x00000A00,  // mem buffer location
    0x20000000,               // location to write prog_blob in target RAM
    sizeof(flash_prog_blob),  // prog_blob size
    flash_prog_blob,          // address of prog_blob
    0x00000100                // ram_to_flash_bytes_to_be_written
};
