/* Flash OS Routines (Automagically Generated)
 * Copyright (c) 2009-2019 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static const uint32_t lpc54018_flash_prog_blob[] = {
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x4d70b570, 0x444d4c70, 0x0110f105, 0xf0004620, 0x69e1fa08, 0x0f20f011, 0x7d21d0fb, 0x0f01f011,
    0xbd70d1f2, 0x4d67b570, 0x444d4c67, 0x0120f105, 0xf0004620, 0xf105f9f6, 0x46200128, 0xf9f1f000,
    0x75212102, 0x4070e8bd, 0x4860e7da, 0xf0106800, 0xd10b0f10, 0x6801485e, 0x4f80f011, 0x6800d006,
    0x4f80f410, 0x485bbf0c, 0x4770485b, 0x47702000, 0xb083b530, 0xf44f2000, 0x90005100, 0x90029001,
    0xf240044a, 0xf8c23026, 0x49541220, 0x66486608, 0x66c86708, 0x668865c8, 0xf8c22003, 0x484b02a0,
    0xf0106800, 0xd10b0f10, 0x68014849, 0x4f80f011, 0x6800d006, 0x4f80f410, 0x4846bf0c, 0xe0004846,
    0x49472000, 0xf0f1fbb0, 0xf8c21e40, 0x46680390, 0xf90bf000, 0x46694c3c, 0xf0004620, 0x4d39f918,
    0x444d4620, 0x0120f105, 0xf99bf000, 0x0128f105, 0xf0004620, 0x2102f996, 0xf7ff7521, 0xb003ff81,
    0xbd302000, 0x47702000, 0x4c2fb570, 0x61e02010, 0xf01169e1, 0xd1fb0f10, 0x46204d2a, 0xf105444d,
    0xf0000120, 0x2100f97e, 0xf10560a1, 0x46200130, 0xf977f000, 0xff64f7ff, 0xbd702000, 0x4c22b570,
    0x20104606, 0x69e161e0, 0x0f10f011, 0x4d1dd1fb, 0x444d4620, 0x0120f105, 0xf963f000, 0x5180f1a6,
    0xf10560a1, 0x46200118, 0xf95bf000, 0xff48f7ff, 0xbd702000, 0x41f0e92d, 0x46064d13, 0x46142010,
    0x69e861e8, 0x0f10f010, 0x4f0ed1fb, 0x444f4628, 0x0120f107, 0xf945f000, 0x5080f1a6, 0xf10760a8,
    0x46280108, 0xf93df000, 0xf8542100, 0x616a2b04, 0xf5b11d09, 0xd3f87f80, 0xff22f7ff, 0xe8bd2000,
    0x000081f0, 0x00000004, 0x40080000, 0x40000610, 0x40000500, 0x02dc6c00, 0x05b8d800, 0x40001000,
    0x016e3600, 0xb2820c01, 0xb5102001, 0x2a204090, 0xf3afd301, 0x29038000, 0x4932bf27, 0x00896048,
    0x4180f101, 0xf8c1bf38, 0xd3030120, 0x4202680a, 0xbd10d0fc, 0x2100f8d1, 0xd0fb4202, 0x0c01bd10,
    0x2001b282, 0x4090b510, 0xd3012a20, 0x8000f3af, 0xbf272903, 0x60884923, 0xf1010089, 0xbf384180,
    0x0140f8c1, 0x680ad304, 0x0202ea30, 0xbd10d0fb, 0x2100f8d1, 0x0202ea30, 0xbd10d0fa, 0x0c05b570,
    0x2101b282, 0x460e4091, 0xd2172a20, 0x00920c02, 0x4c80f102, 0x2d034a13, 0x6051bf2e, 0xf8cc4663,
    0xd3031120, 0x420c6814, 0xe003d0fc, 0x4100f8d3, 0xd0fb420c, 0x4631b280, 0xd3012820, 0x8000f3af,
    0xbf2c2d03, 0xf8cc6091, 0xd3041140, 0xea316810, 0xd0fb0000, 0xf8dcbd70, 0xea310100, 0xd0fa0000,
    0x0000bd70, 0x40040000, 0xb5104a84, 0x20004601, 0xf852447a, 0x428b3020, 0x1c40d002, 0xe002d0f9,
    0xbf082800, 0xf3afbd10, 0xb5108000, 0xf0004604, 0xf64ff907, 0x802070ff, 0x70a0200f, 0x70e02000,
    0x21017120, 0x71a07161, 0x722071e1, 0xb570bd10, 0x4605000c, 0x4601d02b, 0x22004871, 0xf8504478,
    0x428b3022, 0x1c52d002, 0xe020d0f9, 0x496db9fa, 0x23014479, 0x0a0a8809, 0x4479496b, 0xfa037809,
    0x079ef101, 0xbf3d2a03, 0xf1020092, 0xf8c24280, 0x64f31220, 0x4a65bf24, 0x46296151, 0xf8502200,
    0x428b3022, 0x1c52d002, 0xe000d0f9, 0xf3afb10a, 0x485f8000, 0x68004478, 0xff70f7ff, 0x61e82010,
    0xf01069e8, 0xd1fb0f10, 0x882078a1, 0x2270f44f, 0x4101ea02, 0x78e14308, 0x1200f44f, 0x5141ea02,
    0xf44f79a2, 0xea030300, 0x431152c2, 0x79214308, 0xea02011a, 0x430861c1, 0x00527a21, 0x7101ea02,
    0x79e14308, 0xea020052, 0x43087141, 0xea067961, 0x43087181, 0xbd706028, 0xb5104a46, 0x447a2100,
    0x3021f852, 0xd0024283, 0xd0f91c49, 0xb109e000, 0x8000f3af, 0x44784840, 0x88004a40, 0x20010a01,
    0x7812447a, 0x29034090, 0x0089d205, 0x4180f101, 0x0240f8c1, 0x4935bd10, 0x20006188, 0x64c80309,
    0x69c2bd10, 0x0f01f012, 0x2210bf1c, 0xd00361c2, 0xf01269c2, 0xd1fb0f10, 0xf01269c2, 0xd1fb0f02,
    0x788b880a, 0x4c80f44f, 0x020df3c2, 0x3383ea0c, 0x78cb431a, 0x4c00f44f, 0x33c3ea0c, 0x790b431a,
    0x2ce0f44f, 0x4303ea0c, 0x794b431a, 0x1cc0f44f, 0x43c3ea0c, 0x798b431a, 0x0c60f44f, 0x5343ea0c,
    0x431a79c9, 0x6101ea42, 0x47706041, 0xf01269c2, 0xd1fb0f02, 0xf44f790a, 0xea0323e0, 0x794b4202,
    0x1cc0f44f, 0x43c3ea0c, 0x798b431a, 0x0c60f44f, 0x5343ea0c, 0x431a79c9, 0x6101ea42, 0x69c16181,
    0x0f01f011, 0x4770d0fb, 0x0a097501, 0x47707541, 0x7d407d01, 0x2000ea41, 0x00004770, 0x0000023c,
    0x000001f0, 0x000001d8, 0x000001ce, 0x40040000, 0x0000019c, 0x0000012e, 0x00000112, 0x00000108,
    0x60012100, 0x81016041, 0x00004770, 0x0000000a, 0x40080000, 0x0000000a, 0x00000000, 0x00000100,
    0x6b040101, 0x01000100, 0x32040100, 0x00000001, 0x05010000, 0x01000000, 0x20040000, 0x01000000,
    0x06010000, 0x01000001, 0x31010000, 0x01000000, 0xc7010000
};

// Start address of flash
static const uint32_t flash_start = 0x10000000;
// Size of flash
static const uint32_t flash_size = 0x01000000;

/**
* List of start and size for each size of flash sector
* The size will apply to all sectors between the listed address and the next address
* in the list.
* The last pair in the list will have sectors starting at that address and ending
* at address start + size.
*/
static const sector_info_t sectors_info[] = {
    {0x10000000, 0x00001000},
};

static const program_target_t flash = {
    0x20000091, // Init
    0x20000125, // UnInit
    0x20000129, // EraseChip
    0x2000015d, // EraseSector
    0x20000195, // ProgramPage
    0x0,        // Verify

    // BKPT : start of blob + 1
    // RSB  : blob start + header + rw data offset
    // RSP  : stack pointer
    {
        0x20000001,
        0x20000538,
        0x20000800
    },

    0x20000000 + 0x00000A00,  // mem buffer location
    0x20000000,               // location to write prog_blob in target RAM
    sizeof(lpc54018_flash_prog_blob),   // prog_blob size
    lpc54018_flash_prog_blob,           // address of prog_blob
    0x00000100       // ram_to_flash_bytes_to_be_written
};
