/* Flash OS Routines (Automagically Generated)
 * Copyright (c) 2009-2019 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static const uint32_t lpc55S69_flash_prog_blob[] = {
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x20c8b580, 0x0002f2c4, 0x60012120, 0x6080f64f, 0x4100f240, 0x70fff6cf, 0x0100f2c4, 0x500a2200,
    0x6084f64f, 0x70fff6cf, 0x6808500a, 0x6300f04f, 0x30f8f440, 0xf64f6008, 0xf6cf5048, 0x500b70ff,
    0x6028f64f, 0x70fff6cf, 0xf243500b, 0xf2c40010, 0x68030001, 0x4380f443, 0xf8416003, 0xf04f2c80,
    0x21024080, 0xf2406001, 0xf2c0000c, 0x44480000, 0xf862f000, 0xbf182800, 0xbd802001, 0x47702000,
    0xf240b510, 0xf2c0040c, 0xf2460400, 0xeb09636c, 0xf6c60004, 0x21003365, 0x2218f44f, 0xf86cf000,
    0xbf182800, 0xeb09bd10, 0x21000004, 0x2218f44f, 0x4010e8bd, 0xb8b0f000, 0xf240b5b0, 0xf2c0050c,
    0xeb090500, 0x690a0105, 0xf2464604, 0xf6c6636c, 0x46083365, 0xf0004621, 0x2800f84f, 0xbdb0bf18,
    0x0005eb09, 0x46216902, 0x40b0e8bd, 0xb894f000, 0xb085b5f0, 0x070cf240, 0x4606460d, 0x0700f2c0,
    0x0007eb09, 0x462b4631, 0xf0004614, 0xb108f85d, 0xbdf0b005, 0xf10da804, 0x90000c0c, 0x0007eb09,
    0x462a4631, 0xf8cd4623, 0xf000c004, 0xb005f88b, 0x0000bdf0, 0xe7fdbe00, 0x1100f241, 0x3100f2c1,
    0x29006809, 0x680ad00a, 0x0308f240, 0x2207f3c2, 0x0300f2c0, 0x2003f849, 0x47086849, 0x309ef240,
    0x0000f2c0, 0x31abf240, 0x0100f2c0, 0x44794478, 0xf7ff2276, 0xbf00ffdf, 0x0c08f240, 0x0c00f2c0,
    0xc00cf859, 0x0f00f1bc, 0xf241d00b, 0xf2c11c00, 0xf8dc3c00, 0xf1bcc000, 0xd0070f00, 0xc008f8dc,
    0xf2444760, 0xf2c11c3b, 0x47603c00, 0x304ef240, 0x0000f2c0, 0x315bf240, 0x0100f2c0, 0x44794478,
    0xf7ff2286, 0xbf00ffb7, 0x0c08f240, 0x0c00f2c0, 0xc00cf859, 0x0f00f1bc, 0xf241d00b, 0xf2c11c00,
    0xf8dc3c00, 0xf1bcc000, 0xd0070f00, 0xc00cf8dc, 0xf2444760, 0xf2c11c9d, 0x47603c00, 0x20fef240,
    0x0000f2c0, 0x310bf240, 0x0100f2c0, 0x44794478, 0xf7ff2296, 0xbf00ff8f, 0x1300f241, 0x3300f2c1,
    0x2b00681b, 0x691bd001, 0xf2404718, 0xf2c020d0, 0xf2400000, 0xf2c021dd, 0x44780100, 0x229e4479,
    0xff78f7ff, 0x0c08f240, 0x0c00f2c0, 0xc00cf859, 0x0f00f1bc, 0xf241d00b, 0xf2c11c00, 0xf8dc3c00,
    0xf1bcc000, 0xd0070f00, 0xc014f8dc, 0xf2444760, 0xf2c12c7d, 0x47603c00, 0x2082f240, 0x0000f2c0,
    0x218ff240, 0x0100f2c0, 0x44794478, 0xf7ff22b2, 0xbf00ff51, 0x1300f241, 0x3300f2c1, 0x2b00681b,
    0x699bd001, 0xf2404718, 0xf2c02054, 0xf2400000, 0xf2c02161, 0x44780100, 0x22bb4479, 0xff3af7ff,
    0x1100f241, 0x3100f2c1, 0x29006809, 0x69c9d001, 0xf2404708, 0xf2c02028, 0xf2400000, 0xf2c02135,
    0x44780100, 0x22c54479, 0xff24f7ff, 0x1100f241, 0x3100f2c1, 0x29006809, 0x6a09d001, 0xf2404708,
    0xf2c010fc, 0xf2400000, 0xf2c02109, 0x44780100, 0x22cc4479, 0xff0ef7ff, 0x1100f241, 0x3100f2c1,
    0x29006809, 0xf644d004, 0xf2c11151, 0x47083100, 0x10caf240, 0x0000f2c0, 0x11d7f240, 0x0100f2c0,
    0x44794478, 0xf7ff22d2, 0xbf00fef5, 0x230bf644, 0x3300f2c1, 0xbf004718, 0x1c00f241, 0x3c00f2c1,
    0xc000f8dc, 0x0f00f1bc, 0xf8dcd002, 0x4760c040, 0x108af240, 0x0000f2c0, 0x1197f240, 0x0100f2c0,
    0x44794478, 0xf7ff22e0, 0xbf00fed5, 0x21fff644, 0x3100f2c1, 0xbf004708, 0x313df644, 0x3100f2c1,
    0xbf004708, 0x1200f241, 0x3200f2c1, 0x2a006812, 0xf644d004, 0xf2c1328b, 0x47103200, 0x103ef240,
    0x0000f2c0, 0x114bf240, 0x0100f2c0, 0x44794478, 0xf7ff22f5, 0xbf00feaf, 0x1300f241, 0x3300f2c1,
    0x2b00681b, 0x6a5bd001, 0xf2404718, 0xf2c01010, 0xf2400000, 0xf2c0111d, 0x44780100, 0x22fc4479,
    0xfe98f7ff, 0x62a7f644, 0x3200f2c1, 0xbf004710, 0x1c00f241, 0x3c00f2c1, 0xc000f8dc, 0x0f00f1bc,
    0xf8dcd002, 0x4760c02c, 0x00d2f240, 0x0000f2c0, 0x01dff240, 0x0100f2c0, 0x44794478, 0x7284f44f,
    0xfe78f7ff, 0x1200f241, 0x3200f2c1, 0x2a006812, 0x6b12d001, 0xf2404710, 0xf2c000a4, 0xf2400000,
    0xf2c001b1, 0x44780100, 0xf2404479, 0xf7ff120f, 0xbf00fe61, 0x1200f241, 0x3200f2c1, 0x2a006812,
    0x6b52d001, 0xf2404710, 0xf2c00074, 0xf2400000, 0xf2c00181, 0x44780100, 0xf44f4479, 0xf7ff728b,
    0xbf00fe49, 0x1300f241, 0x3300f2c1, 0x2b00681b, 0x6b9bd001, 0xf2404718, 0xf2c00044, 0xf2400000,
    0xf2c00151, 0x44780100, 0xf2404479, 0xf7ff121d, 0xbf00fe31, 0x6c15f644, 0x3c00f2c1, 0xbf004760,
    0x1200f241, 0x3200f2c1, 0x2a006812, 0x6a92d001, 0xf2404710, 0xf2c00008, 0xf2400000, 0xf2c00115,
    0x44780100, 0xf44f4479, 0xf7ff7295, 0x4c46fe13, 0x5f485341, 0x5f495041, 0x45455254, 0x2f2e2e00,
    0x2e2f2e2e, 0x6f732f2e, 0x65637275, 0x70786e2f, 0x63706c2f, 0x36533535, 0x73662f39, 0x61695f6c,
    0x00632e70, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};

// Start address of flash
static const uint32_t flash_start = 0x00000000;
// Size of flash
static const uint32_t flash_size = 0x00098000;

/**
* List of start and size for each size of flash sector
* The size will apply to all sectors between the listed address and the next address
* in the list.
* The last pair in the list will have sectors starting at that address and ending
* at address start + size.
*/
static const sector_info_t sectors_info[] = {
    {0x00000000, 0x00008000},
};

static const program_target_t flash = {
    0x20000021, // Init
    0x2000009d, // UnInit
    0x200000a1, // EraseChip
    0x200000d9, // EraseSector
    0x20000111, // ProgramPage
    0x0,        // Verify

    // BKPT : start of blob + 1
    // RSB  : blob start + header + rw data offset
    // RSP  : stack pointer
    {
        0x20000001,
        0x20000564,
        0x20000800
    },

    0x20000000 + 0x00000A00,  // mem buffer location
    0x20000000,               // location to write prog_blob in target RAM
    sizeof(lpc55S69_flash_prog_blob),   // prog_blob size
    lpc55S69_flash_prog_blob,           // address of prog_blob
    0x00000200       // ram_to_flash_bytes_to_be_written
};
