/* Flash OS Routines (Automagically Generated)
 * Copyright (c) 2009-2019 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static const uint32_t MK_P512_flash_prog_blob[] = {
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0xb5104938, 0x60084449, 0xf24c4837, 0x81c15120, 0x1128f64d, 0x880181c1, 0x0101f021, 0x48348001,
    0x44484932, 0x2200f44f, 0x21006001, 0x1201e9c0, 0x52a0f04f, 0xf44f6142, 0x61825280, 0x1020f880,
    0x62411e49, 0xf939f000, 0xd0002800, 0xbd102001, 0x47702000, 0x4a27b508, 0x9200447a, 0x02cff3c1,
    0x48234601, 0x44482300, 0xf979f000, 0xd0002800, 0xbd082001, 0x491fb508, 0x481d4479, 0x44483920,
    0xf89ff000, 0xd10f2800, 0x4478481a, 0x38324b1a, 0x9000447b, 0x22044816, 0x410cf240, 0xf0004448,
    0x2800f911, 0x2001d000, 0x4b12bd08, 0x4601447b, 0x3b54480f, 0x6200f44f, 0xf0004448, 0xb508b8b6,
    0x1dc94613, 0x0207f021, 0x4479490a, 0x91003972, 0x48074601, 0xf0004448, 0x2800f8f5, 0x2001d000,
    0x0000bd08, 0x00000004, 0x40052000, 0x40020000, 0x00000008, 0x000000a1, 0x0000035c, 0x4604b570,
    0x25006800, 0x061b7803, 0x2370d5fc, 0x20007003, 0x280ce03a, 0xe8dfd236, 0x0a06f000, 0x1a16120e,
    0x2a26221e, 0x6826322e, 0x71f37813, 0x6826e02a, 0x71b37853, 0x6826e026, 0x71737893, 0x6826e022,
    0x713378d3, 0x6826e01e, 0x72f37913, 0x6826e01a, 0x72b37953, 0x6826e016, 0x72737993, 0x6826e012,
    0x723379d3, 0x6826e00e, 0x73f37a13, 0x6826e00a, 0x73b37a53, 0x6826e006, 0x73737a93, 0x6826e002,
    0x73337ad3, 0xb2c01c40, 0xd9c24288, 0x20806821, 0xe0037008, 0x1c416a60, 0x4780d000, 0x78006820,
    0xd5f70600, 0x78006820, 0xd5010681, 0xe0062504, 0xd50106c1, 0xe0022508, 0xd00007c0, 0x46282510,
    0xb508bd70, 0x460b2244, 0x2000f88d, 0x2100466a, 0xbd084798, 0x4614b538, 0xd002078a, 0x7080f44f,
    0x6843bd38, 0xd803428b, 0x441a6882, 0xd80c428a, 0x428b68c3, 0x6902d803, 0x428a441a, 0x2002d801,
    0x1ac9bd38, 0x0100f501, 0x1ac9e000, 0xf88d2208, 0x0c0a2000, 0x2001f88d, 0xf88d0a0a, 0xf88d2002,
    0x466a1003, 0x47a02103, 0xe92dbd38, 0x460745f8, 0x46164698, 0x2000687b, 0x428b198a, 0x68bcd803,
    0x4294441c, 0x68fbd20e, 0xd803428b, 0x441c693c, 0xd2024294, 0xe8bd2002, 0x1acc85f8, 0xf5042500,
    0xe0020400, 0xf44f1acc, 0xfbb46500, 0xfb05f1f5, 0xb1114111, 0x7080f44f, 0xfbb6e7ed, 0xfb05f1f5,
    0xb1a96111, 0xe7e62001, 0xa000f88d, 0xf88d0c20, 0x0a200001, 0x0002f88d, 0x4003f88d, 0x2103466a,
    0x46434638, 0x28004798, 0x1b76d1d5, 0xe001442c, 0x0a09f04f, 0xd1e72e00, 0x4601e7cd, 0x61082000,
    0x477061c8, 0x47fce92d, 0x46074616, 0x2000461d, 0xf8dd198a, 0x078b8028, 0xf44fd003, 0xe8bd7080,
    0x07b387fc, 0x2001d001, 0x687be7f9, 0xd803428b, 0x441c68bc, 0xd20c4294, 0x428b68fb, 0x693cd803,
    0x4294441c, 0x2002d201, 0x1acce7e9, 0x0400f504, 0x1acce000, 0x0a06f04f, 0xd0e02e00, 0xa000f88d,
    0xf88d0c20, 0x0a200001, 0x0002f88d, 0x4003f88d, 0xf88d78e8, 0x78a80004, 0x0005f88d, 0xf88d7868,
    0x78280006, 0x0007f88d, 0x2107466a, 0x46434638, 0x28004798, 0x1d24d1c3, 0x1f361d2d, 0xe92de7dc,
    0x684641fc, 0xeb019d08, 0x428e04c2, 0x6887d803, 0x428f4437, 0x68c7d80a, 0xd804428f, 0xc010f8d0,
    0x428f4467, 0x2002d802, 0x81fce8bd, 0xd80642a6, 0x44376887, 0xd30242a7, 0x24081b89, 0x68c6e00a,
    0xd90342a6, 0x44376907, 0xd3ec42a7, 0x24081b89, 0x0100f501, 0xf6f4fbb1, 0x1416fb04, 0xf44fb114,
    0xe7e17080, 0xf88d2401, 0x0c0c4000, 0x4001f88d, 0xf88d0a0c, 0xf88d4002, 0x0a111003, 0x1004f88d,
    0x2005f88d, 0x3006f88d, 0x2106466a, 0xe7cb47a8, 0xfffffffe, 0x00000000, 0xffffffff, 0xfffffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};

// Start address of flash
static const uint32_t flash_start = 0x00000000;
// Size of flash
static const uint32_t flash_size = 0x00080000;

/**
* List of start and size for each size of flash sector
* The size will apply to all sectors between the listed address and the next address
* in the list.
* The last pair in the list will have sectors starting at that address and ending
* at address start + size.
*/
static const sector_info_t sectors_info[] = {
    { 0x00000000, 0x00000800 },
};

static const program_target_t flash = {
    0x20000021, // Init
    0x20000071, // UnInit
    0x20000095, // EraseChip
    0x200000cb, // EraseSector
    0x200000df, // ProgramPage
    0x0,        // Verify

    // BKPT : start of blob + 1
    // RSB  : blob start + header + rw data offset
    // RSP  : stack pointer
    {
        0x20000001,
        0x20000420,
        0x20000700
    },

    0x20000000 + 0x00000A00,  // mem buffer location
    0x20000000,               // location to write prog_blob in target RAM
    sizeof(MK_P512_flash_prog_blob),   // prog_blob size
    MK_P512_flash_prog_blob,           // address of prog_blob
    0x00000200       // ram_to_flash_bytes_to_be_written
};
