/* Flash OS Routines (Automagically Generated)
 * Copyright (c) 2009-2019 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static const uint32_t rza1xx_flash_prog_blob[] = {
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x41f0e92d, 0x4efe4604, 0xf0106830, 0xd07d0f01, 0x4ffb6961, 0xf44f220e, 0x3f184380, 0xf0004638,
    0x4df7fb08, 0x087ff44f, 0x3d246960, 0xf894b160, 0x22101046, 0x46284643, 0xfafbf000, 0x06bb6821,
    0x4638221e, 0xfaf5f000, 0x220c69a1, 0x5380f44f, 0xf0004638, 0x69a0faee, 0xf894b168, 0x23ff1047,
    0x46282200, 0xfae5f000, 0x221c6861, 0x5340f04f, 0xf0004638, 0x69e1fade, 0xf44f2208, 0x46386370,
    0xfad7f000, 0xb17069e0, 0x220048dd, 0xf04f6ca1, 0x382033ff, 0xfacdf000, 0x221868a1, 0x7340f04f,
    0xf0004638, 0x6a21fac6, 0x220423f0, 0xf0004638, 0x6a20fac0, 0xf814b328, 0x22181f4c, 0xf04f4dd0,
    0x3d1c437f, 0xf0004628, 0x7861fab4, 0x46432210, 0xf0004628, 0x78a1faae, 0xf44f2208, 0x4628437f,
    0xfaa7f000, 0x23ff78e1, 0x46282200, 0xfaa1f000, 0x1c40f854, 0x3c4c2214, 0x1340f44f, 0xf0004638,
    0x220ffa98, 0x4300f44f, 0xe0004638, 0x6b61e027, 0xfa8ff000, 0xf44f6b60, 0xb1783840, 0x1044f894,
    0x4db72210, 0x35184643, 0xf0004628, 0xf894fa82, 0x23071045, 0x46282200, 0xfa7bf000, 0x230f6a61,
    0x46382200, 0xfa75f000, 0x6a604dad, 0xb1d83d48, 0xd0072808, 0xd00a280c, 0xd00d280f, 0x2001e00e,
    0x81f0e8bd, 0x0058f894, 0x0040f885, 0xf8b4e006, 0xf8a50058, 0xe0010040, 0x64286da0, 0x69212210,
    0x46384643, 0xfa55f000, 0x8274f8df, 0x7780f44f, 0x22086aa1, 0xf1a8463b, 0x46400828, 0xfa49f000,
    0x23046ae1, 0x46402202, 0xfa43f000, 0x23026b21, 0x46402201, 0xfa3df000, 0x4f91463b, 0x22086ba1,
    0x4638371c, 0xfa35f000, 0x23106be1, 0x46382204, 0xfa2ff000, 0x23016c21, 0x46382200, 0xfa29f000,
    0x22002301, 0x46404619, 0xfa23f000, 0xf0106830, 0xd0fb0f01, 0x28086a60, 0x280cd004, 0x280fd005,
    0xe006d005, 0x0038f895, 0x8f28e002, 0x6ba8e000, 0x20006520, 0x2100e7a4, 0x60016141, 0x1046f880,
    0x60416181, 0x1047f880, 0x638161c1, 0x64816081, 0x63c16201, 0xf88060c1, 0xf880104c, 0xf880104d,
    0xf880104e, 0x6341104f, 0x1044f880, 0x1045f880, 0x64016241, 0x62816101, 0x630162c1, 0xb5704770,
    0x48684605, 0x4448460c, 0xffd5f7ff, 0x23004a65, 0x444a2001, 0x61506013, 0x5046f882, 0x300ae9c2,
    0x20086310, 0x61136413, 0x46106250, 0x4316e9c2, 0x4070e8bd, 0xb570e6b4, 0x485a4606, 0x4448460d,
    0xffb9f7ff, 0x22004c57, 0x444c2001, 0x61606022, 0x6046f884, 0x200ae9c4, 0x20086320, 0x61226422,
    0x65e265a2, 0x46206260, 0xfe9af7ff, 0xd1022800, 0x1050f894, 0xbd707029, 0x2000494b, 0x1e42b510,
    0x1c40c104, 0xdbfb2810, 0x48482101, 0x68006001, 0x0035f241, 0x82084946, 0x4946200f, 0x48458008,
    0x78013030, 0x0108f021, 0x78007001, 0x483c2200, 0x46112301, 0xf000383c, 0x4c39f98c, 0x6ca13c48,
    0xd4fc0789, 0x23032200, 0x46204611, 0xf981f000, 0xf8b14939, 0xf0400210, 0xf8a100fc, 0x49370210,
    0x0310f8b1, 0x00fcf020, 0x0310f8a1, 0x88014834, 0x01fcf041, 0x48338001, 0xf0218801, 0x800101fc,
    0x88014831, 0x01fcf021, 0x48308001, 0xf0418801, 0x800101fc, 0x492e6820, 0x60204308, 0xf0206820,
    0xf0400078, 0x60200020, 0x492a6860, 0x60604008, 0xf2406de0, 0x43881111, 0x68a065e0, 0x7103f64f,
    0xf4404388, 0x60a07000, 0xf94af000, 0x2001b108, 0x221fbd10, 0xf04f2101, 0x46204300, 0xf939f000,
    0x20006820, 0xb510bd10, 0x4c0d221f, 0xf04f2100, 0x3c484300, 0xf0004620, 0x2100f92c, 0x221060e1,
    0x21eb4807, 0x037ff44f, 0xf0003838, 0x4804f922, 0x22002307, 0x38342101, 0xf91bf000, 0x0000e01c,
    0x3fefa048, 0x00000004, 0xe8201180, 0x3fffff80, 0xfcfe0000, 0xfcfe0408, 0xfcfe7000, 0xfcfe3000,
    0xfcfe3510, 0xfcfe3610, 0xfcfe3a10, 0xfcfe3410, 0x00fff300, 0xfffcfcfc, 0x7103f64f, 0x200061e1,
    0xb510bd10, 0xf93cf000, 0xd1142800, 0x444848a5, 0xfee1f7ff, 0x210148a3, 0x61414448, 0x60012100,
    0xf88021c7, 0xf7ff1046, 0x2800fdcb, 0xe8bdd103, 0xf0004010, 0xbd10b919, 0x4604b510, 0xf920f000,
    0xd1192800, 0x44484897, 0xfec5f7ff, 0x21014895, 0x44482220, 0x21006141, 0xf8806001, 0x22072046,
    0x64846381, 0x608161c2, 0xfdaaf7ff, 0xd1032800, 0x4010e8bd, 0xb8f8f000, 0xe92dbd10, 0x000c47f0,
    0x46054616, 0xf000d056, 0x2800f8fb, 0x4885d152, 0xf7ff4448, 0x4f83fea0, 0x0a00f04f, 0x0801f04f,
    0x444f2202, 0xf8c74638, 0xf8c7a000, 0xf8878014, 0x22072046, 0xa038f8c7, 0xa008f8c7, 0x8028f8c7,
    0x61fa64bd, 0xfd7cf7ff, 0xd1332800, 0xf7ff4638, 0xf8c7fe82, 0xf8c78028, 0x46d08030, 0xa010f8c7,
    0xa040f8c7, 0x2c04e020, 0x200fd305, 0x25046278, 0x65b86830, 0x2c02e00c, 0x200cd305, 0x25026278,
    0x65b88830, 0x2008e004, 0x62782501, 0x65b87830, 0xd80142ac, 0x8028f8c7, 0x44484862, 0xfd50f7ff,
    0xd1072800, 0x442e1b64, 0xd1dc2c00, 0x47f0e8bd, 0xb89af000, 0x87f0e8bd, 0x47f0e92d, 0x48594682,
    0x460d4616, 0xf7ff4448, 0x4f56fe46, 0x0800f04f, 0x21032401, 0x4638444f, 0x8000f8c7, 0xf887617c,
    0x21071046, 0x8038f8c7, 0xa048f8c7, 0x8008f8c7, 0x61f962bc, 0xfd24f7ff, 0x4638bb98, 0xfe2bf7ff,
    0xf8c762bc, 0xf8c78010, 0x62fc8040, 0x2d04e02d, 0x200fd303, 0x62782404, 0x2d02e008, 0x200cd303,
    0x62782402, 0x2008e002, 0x62782401, 0xd80142a5, 0x8028f8c7, 0x4448483b, 0xfd02f7ff, 0xd1b92800,
    0xd0052c04, 0xd0062c02, 0x0050f897, 0xe0067831, 0x68316d38, 0xf8b7e003, 0x88310050, 0x4288b280,
    0x2001d001, 0x1b2de7a6, 0x2d004426, 0x2000d1cf, 0xb510e7a0, 0x40916804, 0x430c439c, 0xbd106004,
    0x2000b508, 0xf88d4669, 0x20050000, 0xfe23f7ff, 0xf89db9e8, 0xf0200000, 0x2001011c, 0x1000f88d,
    0xfdfdf7ff, 0x46692035, 0xfe15f7ff, 0xf89db978, 0xf0200000, 0xf0400039, 0x20310102, 0x1000f88d,
    0xfdedf7ff, 0x46692015, 0xfe05f7ff, 0x2001b108, 0xf89dbd08, 0xf0200000, 0x20110104, 0x1000f88d,
    0xfdddf7ff, 0xbd082000, 0x2005b508, 0xf7ff4669, 0x2800fdf2, 0xf89dd103, 0x07c91000, 0xbd08d1f5,
    0xb5104808, 0xf7ff4448, 0x4806fda6, 0x44482101, 0x21006141, 0x21066001, 0x1046f880, 0x4010e8bd,
    0x0000e48e, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};

// Start address of flash
static const uint32_t flash_start = 0x18000000;
// Size of flash
static const uint32_t flash_size = 0x00800000;

/**
* List of start and size for each size of flash sector
* The size will apply to all sectors between the listed address and the next address
* in the list.
* The last pair in the list will have sectors starting at that address and ending
* at address start + size.
*/
static const sector_info_t sectors_info[] = {
    {0, KB(4)},
};

static const program_target_t flash = {
    0x200202f9, // Init
    0x200203e7, // UnInit
    0x20020463, // EraseChip
    0x20020499, // EraseSector
    0x200204db, // ProgramPage
    0x20020599, // Verify

    // BKPT : start of blob + 1
    // RSB  : blob start + header + rw data offset
    // RSP  : stack pointer
    {
        0x20020001,
        0x20020708,
        0x20020a00
    },

    0x20020000 + 0x00004000,  // mem buffer location
    0x20020000,               // location to write prog_blob in target RAM
    sizeof(rza1xx_flash_prog_blob),   // prog_blob size
    rza1xx_flash_prog_blob,           // address of prog_blob
    0x00000100       // ram_to_flash_bytes_to_be_written
};
