/**
 * @file    flash_blob.c
 * @brief   Flash algorithm for the i.MXRT1050 HyperFlash
 *
 * DAPLink Interface Firmware
 * Copyright (c) 2009-2019, ARM Limited, All Rights Reserved
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static const uint32_t RT1050_IS26KS512S_flash_prog_blob[] = {
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x4605b570, 0x4616460c, 0xcc0fe002, 0x3e10c50f, 0xd2fa2e10, 0xd3022e08, 0xc503cc03, 0x2e043e08,
    0xcc01d307, 0x1f36c501, 0x7821e003, 0x1c647029, 0x1e761c6d, 0xbd70d2f9, 0x4770ba40, 0x4770ba40,
    0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770bac0, 0x4770bac0, 0x4770bac0,
    0x4770bac0, 0x4770bac0, 0x4770bac0, 0x4770bac0, 0x2000b510, 0xf906f000, 0x46c046c0, 0xf0002001,
    0xbd10f8fb, 0xb5104603, 0x079b430b, 0x2a04d10f, 0xc808d30d, 0x1f12c910, 0xd0f842a3, 0xba21ba18,
    0xd9014288, 0xbd102001, 0x43c02000, 0x2a00bd10, 0x07d3d003, 0x1c52d003, 0x2000e007, 0x7803bd10,
    0x1c40780c, 0x1b1b1c49, 0x7803d107, 0x1c40780c, 0x1b1b1c49, 0x1e92d101, 0x4618d1f1, 0xe001bd10,
    0x1f09c004, 0xd2fb2904, 0xd501078b, 0x1c808002, 0xd00007c9, 0x47707002, 0xd00b2900, 0xd00207c3,
    0x1c407002, 0x29021e49, 0x0783d304, 0x8002d502, 0x1e891c80, 0x2200e7e3, 0x2200e7ee, 0x2200e7df,
    0x428b0903, 0x0a03d32c, 0xd311428b, 0x469c2300, 0x4603e04e, 0xd43c430b, 0x08432200, 0xd331428b,
    0x428b0903, 0x0a03d31c, 0xd301428b, 0xe03f4694, 0x428b09c3, 0x01cbd301, 0x41521ac0, 0x428b0983,
    0x018bd301, 0x41521ac0, 0x428b0943, 0x014bd301, 0x41521ac0, 0x428b0903, 0x010bd301, 0x41521ac0,
    0x428b08c3, 0x00cbd301, 0x41521ac0, 0x428b0883, 0x008bd301, 0x41521ac0, 0x428b0843, 0x004bd301,
    0x41521ac0, 0xd2001a41, 0x41524601, 0x47704610, 0x0fcae05d, 0x4249d000, 0xd3001003, 0x40534240,
    0x469c2200, 0x428b0903, 0x0a03d32d, 0xd312428b, 0x018922fc, 0x0a03ba12, 0xd30c428b, 0x11920189,
    0xd308428b, 0x11920189, 0xd304428b, 0xd03a0189, 0xe0001192, 0x09c30989, 0xd301428b, 0x1ac001cb,
    0x09834152, 0xd301428b, 0x1ac0018b, 0x09434152, 0xd301428b, 0x1ac0014b, 0x09034152, 0xd301428b,
    0x1ac0010b, 0x08c34152, 0xd301428b, 0x1ac000cb, 0x08834152, 0xd301428b, 0x1ac0008b, 0xd2d94152,
    0x428b0843, 0x004bd301, 0x41521ac0, 0xd2001a41, 0x46634601, 0x105b4152, 0xd3014610, 0x2b004240,
    0x4249d500, 0x46634770, 0xd300105b, 0xb5014240, 0x46c02000, 0xbd0246c0, 0x20184901, 0xe7febeab,
    0x00020026, 0xf000b510, 0xf000f80b, 0xbd10f802, 0xb5104770, 0xd0012800, 0xffeef7ff, 0x0000bd10,
    0x2100b510, 0xf000a002, 0x2001f813, 0x0000bd10, 0x41474953, 0x3a545242, 0x6e624120, 0x616d726f,
    0x6574206c, 0x6e696d72, 0x6f697461, 0x0000006e, 0x4605b570, 0x200a460c, 0x1c6de000, 0xf812f000,
    0xd0062d00, 0x28007828, 0xe002d1f7, 0xf0001c64, 0x2c00f809, 0x7820d002, 0xd1f72800, 0xf000200a,
    0xbd70f801, 0x4669b508, 0x20037008, 0xbd08beab, 0x06c00a02, 0x0ec0b510, 0xd9012a07, 0xfea8f7ff,
    0x00924b05, 0x681318d2, 0x40842403, 0x408143a3, 0x6013430b, 0x0000bd10, 0x400fc068, 0x4d08b570,
    0x444d2400, 0x04a24907, 0x20004449, 0xfcd3f001, 0x28006068, 0x1c64d102, 0xdbf32c04, 0x0000bd70,
    0x00000004, 0x0000005c, 0x49050102, 0x0912b510, 0x20004449, 0xfcbff001, 0x44494902, 0xbd106048,
    0x0000005c, 0x00000004, 0x2000b57c, 0x43c04914, 0x62c86288, 0x63486308, 0x63c86388, 0x31404910,
    0x49106008, 0x094068c8, 0x300e0140, 0xf00060c8, 0xf002fc9b, 0x480cfc37, 0x490c2500, 0x466a9000,
    0x95014449, 0xf0024628, 0x4c09f9a5, 0x444c4907, 0x44496060, 0xf0012000, 0x6060fce8, 0xbd7c7025,
    0x400fc040, 0x40080000, 0xe0233008, 0x0000005c, 0x00000004, 0xb5104805, 0x68414448, 0xd0032900,
    0xf0004803, 0xbd10f96f, 0xfe32f7ff, 0x0000025c, 0x40184000, 0xf7ffb510, 0xbd10ffed, 0xb5104805,
    0x68814448, 0xd0032900, 0xf0004803, 0xbd10f95b, 0xfe1ef7ff, 0x0000025c, 0x40188000, 0xf7ffb510,
    0xbd10ffed, 0xb5104805, 0x68c14448, 0xd0032900, 0xf0004803, 0xbd10f947, 0xfe0af7ff, 0x0000025c,
    0x4018c000, 0xf7ffb510, 0xbd10ffed, 0xb5104805, 0x69014448, 0xd0032900, 0xf0004803, 0xbd10f933,
    0xfdf6f7ff, 0x0000025c, 0x40190000, 0xf7ffb510, 0xbd10ffed, 0xb5104805, 0x69414448, 0xd0032900,
    0xf0004803, 0xbd10f91f, 0xfde2f7ff, 0x0000025c, 0x40194000, 0xf7ffb510, 0xbd10ffed, 0x460cb510,
    0x29006989, 0x2141d103, 0xf0000549, 0x2000f887, 0x20026120, 0x73603420, 0xb510bd10, 0x2103460c,
    0xf0000589, 0x2000f87b, 0x34206060, 0xbd107320, 0x460bb510, 0x079a6a81, 0x00890889, 0x430a0f92,
    0x69416282, 0x00490fda, 0x07d20849, 0x490b430a, 0x400a4c0a, 0x43e44619, 0x43114021, 0x03a42401,
    0x43a1461a, 0x430a4022, 0x43116941, 0xf0006141, 0x4018f8d1, 0x4802d000, 0x0000bd10, 0xbfe0ffff,
    0x0000051a, 0x461eb5f8, 0x000c4617, 0xd0264605, 0x46202130, 0xfde1f7ff, 0x46202102, 0x73413020,
    0x73012100, 0x62a66267, 0x21106ae8, 0x62e84388, 0xf0004628, 0x4a0bf871, 0x444a0081, 0x490a5054,
    0x44790040, 0x28005e08, 0x06c2db08, 0x21010ed2, 0x09404091, 0x00804a05, 0x60011880, 0xf7ffbdf8,
    0x0000fd67, 0x0000025c, 0x00002eb6, 0xe000e100, 0x6ac1b510, 0x0f490549, 0x6941d1fb, 0xd5fc0249,
    0x61812100, 0xf848f000, 0x00404903, 0x5e084479, 0xf7ff2100, 0xbd10fe9d, 0x00002e7e, 0x23c06902,
    0x021b400b, 0x6102439a, 0x078b6a82, 0x439a0d9b, 0x0a096282, 0x02096982, 0x6182438a, 0x69024770,
    0x400b23c0, 0x431a021b, 0x6a826102, 0x0d9b078b, 0x6282431a, 0x69820a09, 0x430a0209, 0x47706182,
    0x2800b510, 0x21e1d00a, 0x60010249, 0x71012100, 0x71817141, 0x720171c1, 0xbd107241, 0xfd18f7ff,
    0x22c06901, 0x40110a09, 0x69806a82, 0x0f920592, 0x4310430a, 0x00004770, 0xb5104a08, 0x20004601,
    0x0083447a, 0x428b58d3, 0x1c40d003, 0xd3f82808, 0x2808e001, 0xf7ffd301, 0xbd10fcfb, 0x00002db4,
    0x5c40202d, 0xd0072802, 0xd0072a00, 0x69096948, 0x60101a40, 0x47702000, 0x47702006, 0x47702004,
    0x8c0a8c48, 0x8c084290, 0x69cad901, 0x8c491880, 0x47701a40, 0x5c40202c, 0xd0072800, 0xd0072a00,
    0x68496888, 0x60101a40, 0x47702000, 0x47702006, 0x47702004, 0x6a806941, 0x0c0022c3, 0x43084010,
    0x47704770, 0x4605b5f8, 0x460c6940, 0xd50d0300, 0x466969e8, 0x78087008, 0x70081c40, 0x2e006a66,
    0x4a5ed004, 0x46284621, 0x47b06aa3, 0x02816968, 0x30204620, 0x29009000, 0x69a8da71, 0xd56e0280,
    0x01406ae8, 0xe0260f46, 0x42b06920, 0x6920d201, 0x4630e000, 0xb2c168e2, 0xe0022000, 0x541369eb,
    0x460b1c40, 0xd3f94288, 0x184068e0, 0x692060e0, 0x61201a40, 0xb2c61af0, 0x28006920, 0x9800d10b,
    0x73412102, 0x2f006a67, 0x4a44d005, 0x1f924621, 0x6aa34628, 0x2e0047b8, 0x6920d002, 0xd1d32800,
    0x280069a0, 0xe032d12d, 0x46284621, 0xf926f000, 0xd0082800, 0x2f006a67, 0x4a38d005, 0x1e524621,
    0x6aa34628, 0x462147b8, 0xf0004628, 0x2800f917, 0x8c60d009, 0x1c4069e1, 0xd1014288, 0xe0012000,
    0x1c408c60, 0x69e88460, 0x69a18c22, 0x8c205488, 0x1c4069e1, 0xd1014288, 0xe0012000, 0x1c408c20,
    0x46308420, 0xb2f61e76, 0xd1cd2800, 0x6920e007, 0xd1042800, 0x05492141, 0xf7ff4628, 0x6968feef,
    0xd5390200, 0x020069a8, 0x6ae8d536, 0x05402104, 0x1a080f40, 0xe02ab2c6, 0x42b06860, 0x6860d201,
    0x4630e000, 0xb2c16822, 0xe0022000, 0x61eb5c13, 0x460b1c40, 0xd3f94288, 0x18406820, 0x68606020,
    0x60601a40, 0xb2c61af0, 0x28006860, 0x9900d10f, 0x69a87308, 0x05c92101, 0x61a84388, 0x2f006a67,
    0x4a06d005, 0x1fd24621, 0x6aa34628, 0x2e0047b8, 0x6860d002, 0xd1cf2800, 0x0000bdf8, 0x0000051d,
    0xb086b5f7, 0x4604000f, 0x6838d009, 0x28009005, 0x79b8d005, 0xd8022804, 0x280479f8, 0xf7ffd901,
    0x9805fbe7, 0x20009000, 0x25049001, 0x99059002, 0x43699808, 0xfc33f7ff, 0x0c360406, 0x2601d100,
    0x43714629, 0xf7ff9808, 0x9905fc2a, 0x1c701a41, 0x46299103, 0x43419004, 0xf7ff9808, 0x9905fc20,
    0x99031a08, 0xd2024288, 0x98049003, 0x9900b286, 0x42889803, 0x4669d801, 0x1c6dc161, 0xd9d62d20,
    0x98052164, 0xfc0bf7ff, 0x18410041, 0x42819800, 0x4830d202, 0xbdf0b009, 0xf7ff4620, 0x0041fe9d,
    0x4478482d, 0x21035e40, 0xfcf2f7ff, 0x210369a0, 0x43880489, 0x692061a0, 0x1f099901, 0xd2022904,
    0x04492101, 0x211f4308, 0x43880609, 0x1e499901, 0x08c906c9, 0x0b484301, 0x03409902, 0x0cc904c9,
    0x61214301, 0x21016920, 0x43880749, 0x69a06120, 0x43882110, 0x69a061a0, 0x00800880, 0x69a061a0,
    0x43087939, 0x692061a0, 0x03492101, 0x79794388, 0x0c8907c9, 0x61214301, 0x79b979f8, 0x43080400,
    0x6aa062e0, 0x43082188, 0x6aa062a0, 0x03892103, 0x62a04308, 0x7a3969a0, 0xd0022900, 0x04c92101,
    0x7a794308, 0xd0022900, 0x04892101, 0x61a04308, 0xe79f2000, 0x00000521, 0x00002b28, 0x460cb510,
    0xfe5ef7ff, 0x1e4969e1, 0xd1014288, 0xbd102001, 0xbd102000, 0x6ac3e006, 0x0f5b015b, 0x69c3d0fb,
    0x1c49700b, 0xd2f61e52, 0x00004770, 0x460cb5ff, 0x3120b083, 0x7b499100, 0x29034617, 0x69a1d013,
    0x687d2600, 0xd0322900, 0x8110f3ef, 0xb6729101, 0xf7ff4621, 0x2800fe35, 0x4285d01b, 0x4628d200,
    0x21001a2d, 0x481ae013, 0xbdf0b007, 0x69a28c63, 0x683b5cd2, 0x8c62559a, 0x1c5269e3, 0x429a1c76,
    0x2200d101, 0x8c62e001, 0x84621c52, 0x42811c49, 0x2d00d3ec, 0x6838d007, 0x60e01980, 0x61656125,
    0x21039800, 0x98017341, 0x8810f380, 0x6811e00a, 0x612560e1, 0x9a006165, 0x73512103, 0x05492141,
    0xfdadf7ff, 0x28009806, 0x6006d000, 0xe7cb2000, 0x00000515, 0x460bb510, 0x7b1c3320, 0xd00c2c01,
    0x600c6814, 0x604c6854, 0x608a6852, 0x73192101, 0xf7ff05c9, 0x2000fd94, 0x4801bd10, 0x0000bd10,
    0x00000514, 0xb084b5f7, 0xd00d000f, 0x90012000, 0x97002404, 0x46399002, 0x98064361, 0xfb0ff7ff,
    0x0c2d0405, 0xe002d002, 0xfab2f7ff, 0x46212501, 0x98064369, 0xfb03f7ff, 0x1c681bc6, 0x43414621,
    0x98069003, 0xfafbf7ff, 0x42b01a38, 0x4606d202, 0xb2859803, 0x42869800, 0x9600d802, 0x94019502,
    0x2c201c64, 0x2164d9d7, 0xf7ff4638, 0x0041fae8, 0x98001841, 0xd9254281, 0x69819804, 0x22036980,
    0x43900492, 0x61909a04, 0x69009804, 0x1f129a01, 0xd2022a04, 0x04522201, 0x221f4310, 0x43900612,
    0x1e529a01, 0x08d206d2, 0x0b504302, 0x03409a02, 0x0cd204d2, 0x98044302, 0x98046102, 0x20006181,
    0xbdf0b007, 0xe7fb4800, 0x00000521, 0x2900b510, 0x2a00d00b, 0x61cbd008, 0x2200618a, 0x844a840a,
    0x05492141, 0xfd1bf7ff, 0xf7ffbd10, 0xb510fa51, 0xd004000c, 0x5d09212d, 0xd0022902, 0xf7ffe005,
    0x2141fa47, 0xf7ff0549, 0x2000fcf9, 0x61e061a0, 0x84608420, 0xe005bd10, 0x021b6943, 0x780bd5fc,
    0x1c4961c3, 0xd2f71e52, 0x00004770, 0x4d18b570, 0x46160104, 0x444d0924, 0x2001d007, 0x42840340,
    0x7828d11d, 0xd0072800, 0x4912e019, 0x42886830, 0x2001d115, 0xe0127028, 0x22004b0f, 0x4619444b,
    0xf0014610, 0x4b0af8da, 0x444b490b, 0x60682201, 0x03123308, 0x20004449, 0xf8cff001, 0x49066068,
    0x46224633, 0x20004449, 0xf8c7f001, 0xbd706068, 0x00000004, 0x42464346, 0x0000005c, 0x47702000,
    0x4613b570, 0x460a460d, 0x46014604, 0xf7ff4618, 0x2800f9f9, 0x2000d001, 0x1960bd70, 0xb5f8bd70,
    0xb28b0c04, 0xb2824626, 0x0c0d435e, 0x0c374610, 0x04364358, 0x21001980, 0x46164179, 0x0c37436e,
    0x19800436, 0x46264179, 0x1989436e, 0xb430bdf8, 0x1e644674, 0x1c647825, 0xd20042ab, 0x5d63461d,
    0x18e3005b, 0x4718bc30, 0x494db5f8, 0x24016b08, 0x0f800240, 0x6a084084, 0x07404d4a, 0x68280fc2,
    0x03c14f4a, 0xd57d4848, 0xd0012a00, 0xe0002158, 0x23092142, 0x18c9035b, 0x68296029, 0xdafc2900,
    0x23016b29, 0x4399031b, 0x6b296329, 0xdafc2900, 0x6809493f, 0x23034e3f, 0x02db4031, 0x4b3e18c9,
    0x4b3b4319, 0x21036019, 0x61290309, 0x29006929, 0x6929dafc, 0x041b2301, 0x61294399, 0x3b404b34,
    0x40316b19, 0x02362623, 0x4e341989, 0x63194331, 0x21014e33, 0x2a006131, 0x4638d000, 0xf7ff4621,
    0x4930f9ce, 0x44492701, 0x90006008, 0x1c7fe000, 0x98004639, 0xf9c3f7ff, 0x4288492b, 0x6970d8f7,
    0x2207492a, 0x1e794008, 0x0b490749, 0x02a14308, 0x18890292, 0x0cc904c9, 0x02394308, 0x390139ff,
    0x0d890589, 0x61704308, 0x09c06a70, 0x1cc001c0, 0x69b06270, 0x04892103, 0x61b04308, 0x491c69f0,
    0x21034008, 0x18400749, 0x4308491a, 0x682961f0, 0x04002001, 0x60294381, 0x43816b29, 0x69296329,
    0xe0004381, 0x6129e001, 0x2a00bdf8, 0x4638d000, 0xf7ff4621, 0x490bf984, 0x60084449, 0x0000bdf8,
    0x401f4440, 0x400d8000, 0x179a7b00, 0x1f78a400, 0x400d8100, 0xc0c0c0c0, 0x18131818, 0x0f1a2323,
    0x400fc000, 0x0000004c, 0x08954400, 0xfff8e0ff, 0x9c7fff80, 0x03800001, 0x4614b5f8, 0x4607000d,
    0x2c01d024, 0x6c28d822, 0x0fc60640, 0xf0014638, 0x4621fde3, 0x34ff462c, 0x290034c1, 0x7a20d017,
    0xd0092800, 0x5d412046, 0x46384632, 0xf83af000, 0x46384629, 0xfa4ef000, 0x28007ba0, 0x2100d003,
    0xf0004638, 0x4638fca5, 0xf811f000, 0x7a21bdf8, 0xd0072900, 0x46384632, 0xf824f000, 0x46384629,
    0xfa38f000, 0x28007ba0, 0x2101d0ed, 0xb510e7e8, 0xfc66f000, 0xd0012800, 0xfd6ff001, 0xb510bd10,
    0xfc5ef000, 0xd00b2800, 0x23012100, 0x008a07db, 0x32801812, 0x431c6814, 0x1c496014, 0xd3f62904,
    0x0000bd10, 0x460cb5f0, 0xb08b4922, 0x46064615, 0x44792214, 0xf7ff4668, 0x491ef873, 0x44792214,
    0xa8053108, 0xf86cf7ff, 0xd0012d00, 0xd12c2d01, 0x6b184b19, 0x09814f19, 0x018969f8, 0x05d22207,
    0x2d004390, 0xaa05d023, 0xd01e2c00, 0xd9002c09, 0x00642401, 0x18a25d15, 0x785206ac, 0x430c0ea4,
    0x220705d1, 0x188905d2, 0x09ad018d, 0x46304305, 0xf816f000, 0x42a06b18, 0x631cd000, 0x42a869f8,
    0x61fdd000, 0xf0004630, 0xb00bf815, 0x466abdf0, 0x0000e7da, 0x00002416, 0x400d80c0, 0x400fc000,
    0x68014803, 0x02922203, 0x60014391, 0x00004770, 0x400fc080, 0x68014803, 0x02922203, 0x60014311,
    0x00004770, 0x400fc080, 0x4605b5fe, 0x90002004, 0x4628460e, 0xfbe4f000, 0xd07d0004, 0xd0fc2e00,
    0x28037830, 0x7c30d878, 0x27009001, 0xf0014620, 0x4628fd2d, 0xff73f7ff, 0x211e6960, 0x61604308,
    0x35804625, 0x62286870, 0x28027830, 0x2803d002, 0xe003d002, 0xe0008b30, 0xb2878c30, 0x7a307b31,
    0x07001e49, 0x0b000749, 0x43080949, 0x07c99901, 0x43384308, 0x78306268, 0xd1502803, 0x6a3069f1,
    0xd149078b, 0x469e2340, 0x221c6bab, 0x43bb273c, 0x63aa431a, 0x22016bab, 0x63ab4313, 0x07db6bab,
    0x6b2bd1fc, 0x632b4313, 0x1de2e035, 0x32f94673, 0x4570089b, 0x6967d30a, 0xd40206bf, 0xca80e028,
    0x1e5bc180, 0x4672d2fb, 0xe01d1a80, 0x061b6f2b, 0xd1030e1b, 0xca08e01c, 0xc1081f00, 0xd2fa2804,
    0xd0102800, 0x92016812, 0x4694aa01, 0x2300460a, 0x4667e007, 0x7017783f, 0x1c7f4667, 0x46bc1c52,
    0x42831c5b, 0x2000d3f5, 0x23206962, 0x6162431a, 0x07126962, 0xe000d403, 0x2800e05f, 0x7830d1c5,
    0xd0012802, 0xd1412801, 0x69b26971, 0xd1540788, 0x46842040, 0x201c6beb, 0x43bb273c, 0x63e84318,
    0x20016beb, 0x63eb4303, 0x07db6beb, 0x6b2bd1fc, 0x632b4303, 0x4620e028, 0x696330ff, 0x065b3081,
    0x4663d51f, 0x4562089b, 0xe014d202, 0xc080c980, 0xd2fb1e5b, 0x1a124660, 0x2a04e00f, 0xc980d903,
    0x1f12c080, 0x2a00e007, 0xc980d003, 0xc0802200, 0x2700e001, 0x1e5bc080, 0x6960d2ef, 0x43182340,
    0x69606160, 0xd4010700, 0xd1d42a00, 0x28007830, 0x6b28d103, 0x43082101, 0x46206328, 0xfc66f001,
    0x07006960, 0x6e68d50b, 0x0f000100, 0xd001280e, 0xe0014804, 0x1e404803, 0x98009000, 0x2000bdfe,
    0x0000e7fa, 0x00001771, 0xb5104602, 0x2a002004, 0x2900d021, 0x2044d01f, 0x28015c40, 0x68d0d10c,
    0x005b0843, 0x43032040, 0xf0004608, 0x2800fcd3, 0x2001d001, 0x60d34303, 0x212068d0, 0x60d04308,
    0x20004b05, 0x18890081, 0x401c6a0c, 0x1c40620c, 0xd3f72803, 0xbd102000, 0xfcf0ff00, 0xb087b5f3,
    0x2504460c, 0xf0009807, 0x9002facb, 0xd0542800, 0xd0522c00, 0x30404620, 0x90054627, 0x26003750,
    0x304130ff, 0x68389001, 0x0a8100b2, 0x18109802, 0x66019000, 0x1d3f7ba0, 0x7b6006c5, 0x06c00eed,
    0x43050d80, 0x07007be0, 0x43050c40, 0xf0004620, 0x2800fc98, 0x2001d002, 0x43050280, 0x28006f60,
    0xaa03d00d, 0x98072101, 0xfa60f000, 0x6f612301, 0x9a03a804, 0xfa9ef000, 0x04009804, 0x98004305,
    0x98056705, 0x280079c0, 0x9801d00e, 0x07417c00, 0x9901d00a, 0x7c490342, 0x07092007, 0x03400d09,
    0xb2801810, 0xe0014308, 0x02002009, 0x31809900, 0x1c766008, 0xd3b62e04, 0x46282500, 0xbdf0b009,
    0x460db57f, 0xf0004606, 0x0004fa6b, 0x2d00d02c, 0xaa02d02a, 0x46302101, 0xfa28f000, 0x2100aa03,
    0xf0004630, 0x2501fa23, 0x02ad4e10, 0x4631462b, 0x9a024668, 0xfa5ef000, 0x4631462b, 0x9a03a801,
    0xfa58f000, 0x9900480a, 0xd9004281, 0x99019000, 0xd9004281, 0x98009001, 0x04009901, 0x4308b289,
    0x20006060, 0xbd70b004, 0xe7fb2004, 0x1dcd6500, 0x0000ffff, 0xb085b5f3, 0x2404460e, 0xf0009805,
    0x0005fa2f, 0x2e00d07e, 0x7b30d07e, 0xd87b2803, 0xd00a2800, 0xd0082801, 0xd0062802, 0xd1042803,
    0xf0004630, 0x2800fbed, 0x20ffd002, 0xe0093001, 0x2101aa03, 0xf0009805, 0x4935f9d9, 0x42889803,
    0x2079d303, 0x90019000, 0x2400e01e, 0x19800060, 0x8f073040, 0x43472064, 0x214bd01d, 0xf7fe4638,
    0x214bfebe, 0x42b94341, 0x1c40d200, 0x283f213f, 0x4608d900, 0x0c410680, 0x31ff00a2, 0x46683101,
    0x50811c64, 0xd3e12c02, 0x22026828, 0x28000780, 0x2000da1c, 0x4630e01e, 0xfbb9f000, 0x46024607,
    0x9805a902, 0xf9d0f000, 0x9902481a, 0xd0092f00, 0xfe95f7fe, 0x217d0880, 0x434800c9, 0xf7fe214b,
    0xe7d2fe8e, 0xfe8bf7fe, 0xe7f40840, 0x20016829, 0x60294311, 0x29006d31, 0x6d71d102, 0xd0022900,
    0x9b0021c0, 0x6db1514b, 0xd1022900, 0x29006df1, 0x21c4d002, 0x514b9b01, 0xd0022800, 0x43906828,
    0xe0006028, 0x2400e000, 0xb0074620, 0x0000bdf0, 0x05f5e100, 0x3b9aca00, 0xb08ab5f7, 0x2604460d,
    0xf000980a, 0x0007f99d, 0x2d00d053, 0x2001d051, 0x70084669, 0x9001980c, 0x74082000, 0x24002004,
    0x00a09006, 0x46101942, 0x78413020, 0xd03d2900, 0x025b2301, 0x059b59db, 0xd0030f9b, 0x7f5b192b,
    0xd0332b02, 0x78009102, 0x92053230, 0x22009003, 0x9b0c4629, 0xf000980a, 0x2800f90c, 0x9802d12a,
    0x01002101, 0x32801942, 0x980a9b03, 0xfa82f001, 0x90022001, 0x980a4669, 0xfd76f7ff, 0xd1190006,
    0x28008a68, 0x1929d10e, 0x29027f49, 0x2903d00a, 0x2200d008, 0x9b0c4629, 0xf000980a, 0x0006f80d,
    0xe003d108, 0x43482164, 0xfb4cf001, 0x2c031c64, 0x4630d3b7, 0xbdf0b00d, 0x2004b5ff, 0x460cb08f,
    0xd04b2900, 0x900e2000, 0x30404620, 0x21018f82, 0x4095460d, 0x93028fc2, 0x22039200, 0x711a466b,
    0x91039104, 0x9108a90c, 0x29009911, 0x2108d001, 0x2104e000, 0x99119109, 0x79c07519, 0xd0092800,
    0x30ff4620, 0x79013081, 0xd0032900, 0x91037941, 0x90047900, 0x21029803, 0x19020100, 0x9b043280,
    0xf001980f, 0x2002fa27, 0x6f209003, 0xd0022800, 0xfb3ef001, 0x6f20900e, 0xd0112800, 0xfb38f001,
    0x1a40990e, 0xfaf4f001, 0x6f23217d, 0x434b00c9, 0x46112200, 0x41911a18, 0x481ad202, 0xbdf0b013,
    0x980fa901, 0xfd00f7ff, 0xd1f72800, 0x29009911, 0xa90ad019, 0xaa0cab0b, 0x78172608, 0x7857700f,
    0x1c49701f, 0x1c5b1c92, 0xd1f61eb6, 0x9a0b9900, 0x990a2900, 0x4011d005, 0x438a462a, 0x2100d10e,
    0x4311e00d, 0x9900e007, 0xd0032900, 0x46299a0c, 0xe0014391, 0x4029990c, 0xd0002900, 0x29002101,
    0xe7cbd1b9, 0x00001772, 0xb089b5f0, 0x460c4616, 0x25044607, 0xf8b4f000, 0xd0472800, 0xd0452c00,
    0x30ff30ff, 0x68003002, 0x0f800580, 0x7c60d002, 0xd0252802, 0x46692501, 0x9601700d, 0x90027d60,
    0x90037d20, 0x74082000, 0x30184620, 0x20049005, 0x46339006, 0x46212200, 0xf0004638, 0x9802f82a,
    0x01002101, 0x46381902, 0x9b033280, 0xf9a2f001, 0x46384669, 0xf7ff9502, 0x0005fc97, 0xe001d116,
    0xe0132500, 0x29008a61, 0x7c60d10c, 0xd0092802, 0xd0072803, 0x22004633, 0x46384621, 0xff2cf7ff,
    0xe0034605, 0x43482064, 0xfa6cf001, 0xb0094628, 0xb570bdf0, 0x20044604, 0x2900b08a, 0x2000d024,
    0x7030466e, 0x25012003, 0x95039002, 0x20477432, 0x5c409301, 0xd0092800, 0x30ff4608, 0x7a023081,
    0xd0032a00, 0x92027a42, 0x90037a00, 0x9b039802, 0x18420100, 0x46202101, 0xf0013280, 0x4669f95b,
    0x95024620, 0xfc50f7ff, 0xbd70b00a, 0x4616b570, 0x20004a11, 0x6812444a, 0x46044d10, 0xd0052900,
    0xd0082901, 0x60302404, 0xbd704620, 0x05806968, 0x46100f81, 0x69e8e00c, 0x6b004809, 0x0e890681,
    0xf7fe4808, 0x2112fcdc, 0x69e94348, 0x0f490189, 0xf7fe1c49, 0xe7e6fcd4, 0x0000004c, 0x400fc000,
    0x400d80c0, 0x1c9c3800, 0x20044603, 0xd1042b01, 0xd0022900, 0x60084801, 0x47702000, 0x09e4f580,
    0x20004601, 0xd1022900, 0x44784801, 0x47706800, 0x00001ba6, 0x4607b5f8, 0x461d2004, 0x2f00460e,
    0x4611d012, 0xf7fe4809, 0x4601fcaa, 0x43694604, 0xf7fe4630, 0xe000fca4, 0x46011c40, 0x43694361,
    0xd3f942b1, 0x20006038, 0x0000bdf8, 0x3b9aca00, 0x460db570, 0xffd4f7ff, 0xd00a0004, 0xf926f001,
    0x02c02001, 0x2d006821, 0x4301d001, 0x4381e000, 0xbd706021, 0xb087b5f3, 0x2604460d, 0xf7ff9807,
    0x0004ffbf, 0x2d00d07e, 0x7c28d0fc, 0xd1022800, 0x28007f28, 0x6c28d009, 0xd40406c0, 0xf0004628,
    0x2800f986, 0x2001d001, 0x2000e000, 0x49619003, 0x42886828, 0x9807d166, 0xfba2f7ff, 0x98074629,
    0xf8bef000, 0x30404628, 0x90029903, 0xd0022900, 0x21012200, 0x4628e005, 0xf969f000, 0x98024602,
    0x98077981, 0xfb3ef7ff, 0xf7ff9807, 0x6820fb93, 0x43b02602, 0x46206020, 0xf88ff001, 0x43306820,
    0x68206020, 0x4008494c, 0x79499902, 0xd1012908, 0x43080289, 0x43084949, 0x07897b29, 0x43010e89,
    0x46296021, 0xf7ff9807, 0x68a0fcfb, 0x03c92101, 0x60a04388, 0xf0004628, 0x2800f941, 0x68a0d004,
    0x04c92101, 0x60a04308, 0x46204629, 0xfc5cf7ff, 0x98074629, 0xfc82f7ff, 0x98074629, 0xfd1af7ff,
    0x21026820, 0x60204388, 0xf0014620, 0x4628f856, 0x30507c29, 0x29009004, 0x9807d01c, 0x20049005,
    0xe0002100, 0x9e04e052, 0x460f9100, 0x9101ce02, 0xd00a2900, 0x9a004629, 0xf7ff9805, 0x2800fe75,
    0x9a01d106, 0x18899900, 0x1c7f9100, 0xd3ed2f04, 0xd13b0006, 0x28007f28, 0x9807d01c, 0x20049005,
    0xd0152d00, 0x9e042100, 0x460f9100, 0x9101ce02, 0xd00a2900, 0x9a004629, 0xf7ff9805, 0x2800fd6d,
    0x9a01d106, 0x18899900, 0x1c7f9100, 0xd3ed2f04, 0xd11b0006, 0x28009803, 0x6820d017, 0x43302602,
    0x46286020, 0xf8d3f000, 0x98024602, 0x98077981, 0xfaa8f7ff, 0x98074629, 0xfc82f7ff, 0x98074629,
    0xfcb8f7ff, 0x43b06820, 0x26006020, 0xb0094630, 0x0000bdf0, 0x42464346, 0x0000df0f, 0xffff0000,
    0x4d53b5fe, 0x462e4853, 0x460c9001, 0x46084637, 0xf8b9f000, 0xd0042800, 0x6ee06e26, 0x6e679001,
    0x46206ea5, 0x6d213040, 0x6d609000, 0xd0232900, 0xd0042800, 0x20064948, 0x484863c8, 0x6d2062c6,
    0xd0062800, 0x20014944, 0x62c83140, 0x30404843, 0x484161c6, 0x30402311, 0x49406303, 0x620f3140,
    0x63422201, 0x6382624d, 0x9800628d, 0x28047940, 0x2808d005, 0xe01bd003, 0xd1db2800, 0x4936e030,
    0x31402001, 0x493563c8, 0x62cd3140, 0x32804a32, 0x630d6010, 0x79529a00, 0xd1092a08, 0x32404a2e,
    0x610d6210, 0x60cd61d0, 0x608d6190, 0x604d6150, 0x28037b20, 0x2801d001, 0x4827d106, 0x62833040,
    0x98014926, 0x61883140, 0xf0004620, 0x2800f857, 0x4921d006, 0x31402001, 0x48206248, 0x61473040,
    0x28006da0, 0xd0216de0, 0xd0052800, 0x2006491a, 0x60083140, 0x63064819, 0x28006da0, 0x4816d005,
    0x30402104, 0x481560c1, 0x491363c6, 0x31402011, 0x4a126248, 0x61573240, 0x62082001, 0x61c86115,
    0x9b0060d5, 0x2b04795b, 0xe006d003, 0xd1dd2800, 0x6188bdfe, 0x61486095, 0x7b206055, 0xd0012803,
    0xd1f52801, 0x61082014, 0x60109801, 0x0000bdfe, 0x000010f1, 0x000130f1, 0x401f8180, 0x401f8380,
    0x07806c00, 0x2001d501, 0x20004770, 0x6c004770, 0xd5010640, 0x47702001, 0x47702000, 0x07c06c00,
    0x2001d000, 0x6c004770, 0xd5010680, 0x47702001, 0x47702000, 0x07406c00, 0x2001d501, 0x20004770,
    0x6c004770, 0xd5010700, 0x47702001, 0x47702000, 0xb08ab570, 0x20004605, 0x7030466e, 0x2401200f,
    0x94039002, 0x460a7432, 0x930132ff, 0x46233271, 0x46284621, 0xff0ef000, 0x46284669, 0xf7ff9402,
    0xb00afa03, 0xb5ffbd70, 0xb0812004, 0x2900460f, 0x463dd016, 0x358135ff, 0x46146c6e, 0x18b21e71,
    0x438c1e5b, 0x438e18d6, 0x4622e008, 0x98014639, 0xf881f000, 0xd1032800, 0x190c6c69, 0xd3f442b4,
    0xbdf0b005, 0xb08bb5f3, 0x46692000, 0x70089d0c, 0x91032101, 0x9102210b, 0x74084669, 0x5d402047,
    0xd0092800, 0x30ff4628, 0x7d013081, 0xd0032900, 0x91027d41, 0x90037d00, 0x990c2200, 0xf7ff980b,
    0x2600f90b, 0x46373550, 0xcd01950a, 0x28009009, 0x4633d01a, 0x990c2200, 0xf000980b, 0x0004fe86,
    0x9802d13e, 0x01019601, 0x9b03980c, 0x2101180a, 0x980b3280, 0xfeaef000, 0x90022001, 0x980b4669,
    0xf9a2f7ff, 0xd12b0004, 0x1c7f9809, 0x2f041836, 0x2c00d3db, 0x2000d124, 0x46069009, 0x9d0a980c,
    0x30c130ff, 0xcd80900a, 0xd0132f00, 0x9b092200, 0x980b990c, 0xfc30f7ff, 0xd1110004, 0x7bc0980a,
    0xd0072800, 0x9b092200, 0x980b990c, 0xfe2cf000, 0xd1050004, 0x1c769809, 0x900919c0, 0xd3e22e04,
    0xf7ff980b, 0x2201f8f4, 0x980b990c, 0xf8b4f7ff, 0xb00d4620, 0xb5f7bdf0, 0x4617b08a, 0x4608460d,
    0xff38f7ff, 0x22004606, 0x980a4629, 0xf8a4f7ff, 0x4632463b, 0x980a4629, 0xfe27f000, 0xd1390004,
    0x97014669, 0x20057008, 0x90022401, 0x740e9403, 0x5d402047, 0xd0092800, 0x30ff4628, 0x7b013081,
    0xd0032900, 0x91027b41, 0x90037b00, 0x21019802, 0x19420100, 0x9b033280, 0xf000980a, 0x4669fe3b,
    0x980a9402, 0xf930f7ff, 0xd1130004, 0x4632463b, 0x980a4629, 0xfbd0f7ff, 0xd10b0004, 0x30d020ff,
    0x28005d40, 0x463bd006, 0x46294632, 0xf000980a, 0x4604fdcb, 0xf7ff980a, 0x2201f89a, 0x980a4629,
    0xf85af7ff, 0xb00d4620, 0xb5f8bdf0, 0x4607460d, 0xfd30f7ff, 0xd11e0006, 0x3280462a, 0x46142301,
    0x46382100, 0xfe06f000, 0x30cd20ff, 0x28025d40, 0x7c68d003, 0xd00c2801, 0x4620e00d, 0xc80f3020,
    0x35104625, 0x4620c50f, 0xc80f3040, 0xc40f3430, 0x2000e001, 0x46307428, 0xb5ffbdf8, 0x4617b089,
    0x4608460d, 0xfeb6f7ff, 0x22004606, 0x98094629, 0xf822f7ff, 0x4632463b, 0x98094629, 0xfda5f000,
    0xd13f0004, 0x46692002, 0x20097008, 0x90022401, 0x20479403, 0x46285d41, 0x308130ff, 0xd0062900,
    0x29007c01, 0x7c41d003, 0x7c019102, 0x46699103, 0x740e9701, 0x9105990c, 0x90066c00, 0x21019802,
    0x19420100, 0x9b033280, 0xf0009809, 0x4669fdb3, 0x98099402, 0xf8a8f7ff, 0xd1130004, 0x4632463b,
    0x98094629, 0xfb48f7ff, 0xd10b0004, 0x30d020ff, 0x28005d40, 0x463bd006, 0x46294632, 0xf0009809,
    0x4604fd43, 0xf7ff9809, 0x2201f812, 0x98094629, 0xffd2f7fe, 0xb00d4620, 0x0000bdf0, 0xb089b5ff,
    0x9c122004, 0x4616461f, 0xd0222900, 0xd0202e00, 0xd01e2c00, 0xf7ff4608, 0x2103fe4d, 0x7011466a,
    0x91032101, 0x91022100, 0x4d0b7410, 0xd80042ac, 0x46694625, 0x96079701, 0x98099508, 0xf864f7ff,
    0xd1062800, 0x008908a9, 0x197f1b64, 0x2c00198e, 0xb00dd1eb, 0x0000bdf0, 0x0000ffff, 0x460cb5f7,
    0xb0a64958, 0x4f564615, 0x44792240, 0xf7fea815, 0x2000f867, 0x46269000, 0x36402004, 0x68287170,
    0x0f010300, 0x0f00d005, 0xd0062802, 0xd0092803, 0x2010e093, 0x20006420, 0x2050e002, 0x20036420,
    0xe0077320, 0x64202050, 0x73202003, 0x71702008, 0x90002001, 0x98264621, 0xff17f7ff, 0xd17c0007,
    0xa9156828, 0x0f000300, 0x18420100, 0x46192301, 0xf0009826, 0xa901fd1f, 0x98269a00, 0xfc54f000,
    0xd16a0007, 0xa901aa25, 0xf0004620, 0x2050fd77, 0x20036420, 0x46207320, 0x30804933, 0x49336301,
    0x88296101, 0x04092302, 0x1de10f0a, 0x2a0231f9, 0x2a03d002, 0xe050d027, 0x71722204, 0x0312682a,
    0xd10d0f12, 0x04922221, 0x4a2961a2, 0x4a296602, 0x22016642, 0x74637422, 0x75652506, 0x82627522,
    0x60024a25, 0x60424a25, 0x64024a25, 0x32154a22, 0x22336502, 0x630a0152, 0x3a094a1f, 0x4a21610a,
    0x4921614a, 0x2208e025, 0x682a7172, 0x0f120312, 0x2211d10d, 0x61a204d2, 0x66024a15, 0x66424a15,
    0x74222201, 0x25067463, 0x75227565, 0x4a178262, 0x4a176002, 0x4a176042, 0x4a146402, 0x65023215,
    0x0152223b, 0x4a11630a, 0x610a3a09, 0x614a4a12, 0x34ff4912, 0x620134c1, 0x46387323, 0xbdf0b029,
    0x00004e8d, 0x000014aa, 0x00000406, 0x24040405, 0x04000471, 0x00002003, 0x8a20060b, 0x0000a604,
    0x00000606, 0x0000a280, 0xa6040605, 0x8b20070b, 0x0000a704, 0x00000706, 0x0000a380, 0xa7040705,
    0x460fb5f7, 0x2103b088, 0x73f94638, 0x30402308, 0x23587143, 0x2401643b, 0x2a007339, 0x2159d001,
    0x71c46439, 0x8781210f, 0x463e87c4, 0x36ff2001, 0x36810240, 0x02406430, 0x46396470, 0xf7ff9808,
    0x2800fe54, 0x4862d139, 0x90002500, 0x95034861, 0x90012301, 0x466a9502, 0x98084619, 0xfc5af000,
    0x95039502, 0x485c4d5a, 0x90013580, 0x466a2301, 0x95002100, 0xf0009808, 0x2013fc4d, 0x900602c0,
    0xaa062302, 0x98084955, 0xfb50f000, 0xd1142800, 0xaa042308, 0x98082110, 0xfb34f000, 0xd10c2800,
    0x494f9805, 0x9005b280, 0x42889804, 0x2159d104, 0x02099805, 0xd0024288, 0xb00b484a, 0x2308bdf0,
    0x2127aa04, 0xf0009808, 0x2800fb1d, 0x9804d1f5, 0x0e000400, 0x38179004, 0xd8ed2809, 0x20019904,
    0x65384088, 0x0300200f, 0x23029006, 0x2100aa06, 0xf0009808, 0x2800fb1b, 0x463cd1df, 0x49363480,
    0x60616025, 0x4a394938, 0x34104b39, 0x4b39c40e, 0x60236065, 0x60a34b38, 0x60e34b38, 0x34144b34,
    0x4b37c40e, 0x602260a3, 0x4b366061, 0x4b3460e3, 0x61234625, 0x4b2e3554, 0x4b33c50e, 0x4b24602b,
    0x3b203414, 0x4b31606b, 0x4b2960ab, 0x4b30c40e, 0xc4083d1c, 0xc40e4b26, 0x60a34b29, 0x60616022,
    0x60e34b28, 0x61234b26, 0x462c4b19, 0x602b3b20, 0x606b4b28, 0x60ab4b28, 0x34304b1d, 0x4b24c40e,
    0x4b1b63eb, 0xc40e1d24, 0x656b4b1d, 0x652964ea, 0x65ab4b1c, 0x65eb4b1a, 0x6629666a, 0x66a94914,
    0x66e9491e, 0x72312102, 0x72722203, 0x22017131, 0x74317172, 0x74712109, 0x73312104, 0x73732305,
    0x210b7531, 0x757137ff, 0x733a37c1, 0x0000e775, 0x8b188720, 0xa3028f10, 0xa7048f10, 0x00000555,
    0x52005100, 0x00004e8d, 0x87008700, 0x87aa8700, 0x87058700, 0x87708700, 0xb70b8f10, 0x0000a704,
    0x87558700, 0x87028700, 0x87a08700, 0xa3808f10, 0x87808700, 0x87008f10, 0x00008730, 0x87108700,
    0x460cb5f7, 0xb09e4954, 0x22204616, 0xa8144479, 0xfe86f7fd, 0x03006830, 0xd00e0f00, 0x73202003,
    0x46272050, 0x37402108, 0x71796420, 0x981e4621, 0xfd4bf7ff, 0xd10b0005, 0x2000e003, 0x20107320,
    0x6830e7ef, 0x0f010300, 0x0f00d003, 0xd0032803, 0x2301e07e, 0xe001aa14, 0xaa182301, 0x981e2101,
    0xfb48f000, 0x71782008, 0x46692200, 0xf000981e, 0x0005fa7b, 0xaa1cd16c, 0x46204669, 0xfb9ef000,
    0x64202050, 0x73202003, 0x49344620, 0x63013080, 0x61014933, 0x46236832, 0x0f0f0311, 0x1de133ff,
    0x31f933c1, 0xd0062f03, 0x0f170412, 0xd0022f03, 0xd01a0f12, 0x4a2be04c, 0x4a2b6202, 0x4a2b6002,
    0x4a2b6042, 0x4a286402, 0x65023adc, 0x0152223b, 0x4a25630a, 0x610a3aeb, 0x614a4a26, 0x22026831,
    0x0f090309, 0xd0222900, 0x6d22e031, 0x06242401, 0xd30242a2, 0x228e2420, 0x2418e001, 0x9e1c22c2,
    0xb2f60424, 0x4f1c4326, 0x4c1c4322, 0x4322433e, 0x610a6506, 0x01d22247, 0x4a19614a, 0x4a136002,
    0x20236042, 0x63080140, 0x73982001, 0x2101e010, 0x74627421, 0x61a626e7, 0x75662606, 0x82617521,
    0x66014910, 0x3981490f, 0x490f6641, 0x731a6681, 0xb0214628, 0x0000bdf0, 0x000010c8, 0x00000406,
    0x24040405, 0xa7040705, 0x8b2007fd, 0x0000a704, 0x00000706, 0x0000a304, 0x08000400, 0x0b000400,
    0x8b2004fd, 0x04000481, 0x00002001, 0x460cb5f7, 0xb092494b, 0x22204615, 0xa8094479, 0xfdc0f7fd,
    0x26006828, 0x0f010300, 0x29002703, 0x0f00d005, 0xd0072803, 0xb0152004, 0x7326bdf0, 0x64202010,
    0xe0049708, 0x20507327, 0x20066420, 0x21089008, 0x55012045, 0x98124621, 0xfc77f7ff, 0xd1ea2800,
    0x03006828, 0xd0370f00, 0xaa0d2301, 0x98122101, 0xfa80f000, 0x96014668, 0x70077406, 0x48312601,
    0x44489602, 0x90079603, 0x98124669, 0xfd6cf7fe, 0xd1d02800, 0x4449492b, 0x2ac2780a, 0x682ad1cb,
    0x0f130312, 0xd01a4a28, 0x23027949, 0x408a3930, 0x46216522, 0x31ff2201, 0x31810312, 0x1112644a,
    0x7327640a, 0x64212150, 0x03096829, 0x46210f0a, 0x2a003180, 0xe012d005, 0xaa092301, 0x7889e7c6,
    0x7426e7e3, 0x82667463, 0x75622206, 0x4a177526, 0x660a61a3, 0x3a724a15, 0x4a15664a, 0x4a15668a,
    0x4a15600a, 0x4a15604a, 0x4a15630a, 0x4a15640a, 0x4a15610a, 0x4a15620a, 0x628a624a, 0x62ca4a14,
    0x32f91de2, 0x61154d13, 0x61554d13, 0x650d4d13, 0x654d4d13, 0x34ff4913, 0x631134c1, 0xe77a7323,
    0x00000f1c, 0x00000054, 0x00010000, 0x04000472, 0x20010400, 0x871187ee, 0xa7048b20, 0x00000406,
    0x87f98706, 0x24040405, 0x87fa8705, 0x87008700, 0x0000a704, 0x87ed8712, 0xa3048b20, 0x87de8721,
    0x00008b20, 0x879f8760, 0x2000b5f7, 0x460cb0b2, 0x25044616, 0x900c4941, 0x900e900d, 0x44792230,
    0x4668900f, 0xfcfcf7fd, 0x03006830, 0xd1720f00, 0x20044627, 0x71783740, 0x49394620, 0x60013080,
    0x60414938, 0x98324621, 0xfbbff7ff, 0xd1620005, 0x06007830, 0x28010f00, 0x1de0d10e, 0x30f94932,
    0x67416701, 0x67811409, 0x461a2300, 0x98324621, 0xfa9ef7ff, 0xd14e0005, 0x46696830, 0x0f000300,
    0x18420100, 0x46192301, 0xf0009832, 0x2200f9b3, 0x9832a91d, 0xf8e8f000, 0xd13c0005, 0xa9102003,
    0x20017008, 0x20009013, 0x74089012, 0xa8199011, 0x20109017, 0x98329018, 0xfc96f7fe, 0xd12a0005,
    0x9919481a, 0xd11f4281, 0x02402001, 0xa9109018, 0x98329417, 0xfc88f7fe, 0xd11c0005, 0x30ff4620,
    0x6c013081, 0xd0021c49, 0x1c406c40, 0x2101d113, 0x46200249, 0xfd21f7fd, 0x6020480c, 0x6060480c,
    0x71b82001, 0x65200600, 0xaa1d4633, 0x98324621, 0xfacaf000, 0x46284605, 0xbdf0b035, 0x00000d66,
    0x08180403, 0x00012404, 0x06ff06ff, 0x42464346, 0x56010400, 0x2604b5f7, 0x460c4615, 0xd04b2900,
    0xd0492d00, 0x462001f1, 0xfcf7f7fd, 0x46272101, 0x71b93740, 0x65200608, 0x60204820, 0x60604820,
    0x73602003, 0x20ff73a0, 0x550130c9, 0x02006828, 0x00030f00, 0xfabbf7fe, 0x0c060609, 0x1d301711,
    0x00302330, 0x4621462a, 0xf7ff9800, 0xe001ff3d, 0xe0032201, 0xd0180006, 0x2200e01e, 0x98004621,
    0xfc9ef7ff, 0x462ae7f6, 0x98004621, 0xfe6ef7ff, 0x462ae7f0, 0x98004621, 0xfda2f7ff, 0x462ae7ea,
    0x98004621, 0xfbbaf7ff, 0x4620e7e4, 0xf8f3f000, 0x07007828, 0x71b80f00, 0xbdfe4630, 0x42464346,
    0x56010400, 0xb089b530, 0x466d2403, 0x2501702c, 0x24000049, 0x91019503, 0x466d9402, 0x4669742c,
    0x92079308, 0xfbf0f7fe, 0xbd30b009, 0xb089b530, 0x466d2402, 0x2401702c, 0x91010049, 0x94039402,
    0x74292100, 0x93064669, 0xf7fe9205, 0xb009fbdd, 0xb5f0bd30, 0x20044607, 0x461db089, 0x460e4614,
    0xd00f2a00, 0x46682124, 0xfc77f7fd, 0x46692003, 0x20017008, 0x95089002, 0x96019003, 0x46389407,
    0xfbc2f7fe, 0xbdf0b009, 0xb098b5f7, 0x4d33460e, 0x466a2308, 0x98182100, 0xffdbf7ff, 0xd15a0004,
    0x9800492f, 0xd0014288, 0xe054462c, 0x79804668, 0x280a1c40, 0x200ad900, 0x981a9016, 0x28002108,
    0x0209d000, 0xaa029816, 0x981800c3, 0xffc1f7ff, 0xd1400004, 0x46302150, 0xfc3ff7fd, 0xe0372500,
    0xaa0200e8, 0x18835c11, 0x020079d8, 0x20ff180a, 0x42820200, 0x481bd002, 0xd1284282, 0x20022100,
    0x1819020f, 0x43397909, 0xd5f91e40, 0x008778d8, 0x2800981a, 0x0209d000, 0x020020ff, 0xd1084282,
    0x1d32463b, 0xf7ff9818, 0x0004ff94, 0x6037d113, 0x480ce00d, 0xd10a4282, 0x463b4632, 0x98183248,
    0xff87f7ff, 0xd1060004, 0x20442101, 0x1c6d5581, 0x42859816, 0x4620d3c4, 0xbdf0b01b, 0x00004e8b,
    0x50444653, 0x0000ff84, 0xb089b5ff, 0x4616461d, 0x9809460c, 0xfecdf7fe, 0xd1142800, 0x70084669,
    0x200e2701, 0x90029703, 0x4622740e, 0x326132ff, 0x4639463b, 0x98099501, 0xf83cf000, 0x97024669,
    0xf7fe9809, 0xb00dfb31, 0xb5f8bdf0, 0x20ff4607, 0x5c4030ce, 0x4616461d, 0x2800460c, 0x4638d004,
    0xf906f7ff, 0xd1052800, 0x4632462b, 0x46384621, 0xfe9ff7fe, 0x2104bdf8, 0xd00c2800, 0x29037b01,
    0x6c01d108, 0x06493040, 0xda012900, 0xe000210f, 0x8701211e, 0x46082100, 0x68014770, 0x43112201,
    0x68016001, 0xd1fc07c9, 0x8f4ff3bf, 0x8f6ff3bf, 0x00004770, 0x460eb5f8, 0x461f2104, 0x91004615,
    0xfedef7fe, 0xd0230004, 0xd0212d00, 0x19f22100, 0x23104149, 0x1a9a2000, 0xd3194188, 0xf0004620,
    0x4a0cf825, 0x200261a2, 0x19f161e0, 0x008b00b0, 0x19090081, 0x31ff31ff, 0xe0023102, 0xc140cd40,
    0x42981c40, 0x61a2d3fa, 0x61e02001, 0x90002000, 0xbdf89800, 0x5af05af0, 0xf7feb510, 0x2800feb1,
    0x3080d003, 0x07896e01, 0xbd10d5fc, 0x6e013080, 0xd0fc07c9, 0x07896e01, 0x4770d5fc, 0x4805b510,
    0x05806940, 0x48040f81, 0x44481c49, 0xf7fd6800, 0xbd10fb56, 0x400fc000, 0x0000004c, 0x4805b510,
    0x05806940, 0x48040f81, 0x44481c49, 0xf7fd6800, 0xbd10fb46, 0x400fc000, 0x0000004c, 0x460ab5f7,
    0x46963248, 0x1d0d688a, 0x2a002301, 0x461cda03, 0x40941ed2, 0x1c52e001, 0x650408d4, 0x30ff27ff,
    0x3701680a, 0x46a43081, 0xd2012a40, 0xe00a6407, 0x06128d2a, 0x461a0f14, 0x240140a2, 0x42a203e4,
    0x463ad100, 0x4c126402, 0x00532200, 0x7f1f195b, 0xd0052f00, 0x40bb2301, 0xd20142a3, 0x4616461c,
    0x2a041c52, 0x2201d3f1, 0x64440612, 0xd9074594, 0x79083140, 0xd0032800, 0x19804670, 0xe0027901,
    0x19400070, 0x98027f41, 0x20006001, 0x0000bdfe, 0x0000ffff, 0x20ff4a0e, 0x68526851, 0x0f890609,
    0x0f920692, 0xd0072900, 0xd00f2901, 0xd00d2902, 0xd1002903, 0x47702002, 0xd0032a00, 0xd0032a01,
    0x47702020, 0x47702001, 0x47702010, 0x47702008, 0x400f8000, 0x47704800, 0x01312d00, 0x68024803,
    0x438a2103, 0x6002430a, 0x00004770, 0x400fc080, 0xb5104903, 0x00c04449, 0xf7fd6809, 0xbd10fac0,
    0x00000050, 0x4602b570, 0xf832f000, 0x4909460d, 0x44494604, 0x68094610, 0xf871f7fe, 0x08c3074a,
    0x08ca4313, 0x416a191c, 0xf822f000, 0x41911b00, 0xbd70d3fa, 0x00000050, 0x4809b510, 0x69c06941,
    0x0f890589, 0x48070684, 0x44480ea4, 0x1c496800, 0xf7fd1c64, 0x4621fa94, 0xfa91f7fd, 0x0000bd10,
    0x400fc000, 0x0000004c, 0xf7ffb510, 0xbd10ff27, 0x4803b508, 0x6a406a01, 0x43c09000, 0xbd0843c9,
    0x400840c0, 0x4813b510, 0x68012304, 0x03122203, 0x43114391, 0x48106001, 0x60012100, 0x1e4a480f,
    0x61816102, 0x61c42401, 0x43196981, 0x69816181, 0x61814321, 0x60c46002, 0xf7ff6084, 0x00c0ffbd,
    0xf7fd4907, 0x4907fa5c, 0x44492800, 0xd1006008, 0xbd10600c, 0x400fc06c, 0x40084000, 0x40084100,
    0x000f4240, 0x00000050, 0xb089b5ff, 0x90032004, 0x460e980b, 0x90021d00, 0x3048980b, 0x20009007,
    0x980c9001, 0x02006800, 0x28010f00, 0x9802d105, 0x03006800, 0x90010fc0, 0x2000d07e, 0x980c7330,
    0x7800aa08, 0x0f090701, 0x55812046, 0x90042018, 0x90052000, 0x990b4630, 0xfee0f7ff, 0x6d302101,
    0x42880609, 0x980bd906, 0x79003040, 0xd0012800, 0x90042020, 0x8800980c, 0x0f000400, 0x4631d15c,
    0x9a0b9b0c, 0xf0009809, 0x9003f9af, 0xd1f52800, 0x68009802, 0xd5080281, 0x90052002, 0x7a009802,
    0x0f4f0601, 0x0ec006c0, 0x0240e007, 0x9802d506, 0x02016880, 0x02c00f4f, 0x90000ec0, 0x98041df4,
    0x34f94a95, 0xd0012820, 0xe00e4894, 0x49949807, 0x05c36800, 0x4893d501, 0x0600e002, 0x4892d503,
    0x61206161, 0x4890e003, 0x61623011, 0x20016120, 0x46357330, 0x3580488d, 0x488d6328, 0x98086128,
    0x9804b2c1, 0x43010400, 0x488a9006, 0x20234301, 0x65290140, 0x980c6320, 0x01006800, 0xd00f0f00,
    0x6840980c, 0x0e090601, 0x9901d00a, 0xb2c02700, 0x29009000, 0xe000d01f, 0x0040e069, 0xe01a9000,
    0x28009801, 0x9804d017, 0xd1042820, 0x30124876, 0x48796028, 0x46316068, 0xf7fe9809, 0x9003ffe6,
    0xd18b2800, 0x4631466a, 0xf0009809, 0x9003f9b5, 0xd14c2800, 0x98042700, 0xd0062818, 0x90052002,
    0x28009801, 0x20eed01d, 0x9801e003, 0xd0082800, 0x6c3120ed, 0x43112240, 0x99066431, 0x48674301,
    0x9802e025, 0x02816800, 0x9802d503, 0x04008900, 0x0240e003, 0x9802d503, 0x0e006880, 0x2003e011,
    0x9807e00c, 0x06816800, 0x20ecd501, 0x06c0e009, 0x206cd503, 0x91052100, 0x2013e003, 0x460f2100,
    0x99069100, 0x98054301, 0x43010600, 0x46334851, 0x60294301, 0x33ff990c, 0x33c17809, 0x20000609,
    0x93050f0a, 0xd0032a00, 0x29010f09, 0xe06bd004, 0x19c09800, 0xe0499000, 0x6809990b, 0xd3f72940,
    0x6b899902, 0xd5f3058a, 0x0f090309, 0x42112205, 0x20a5d001, 0x0789e00b, 0x4631d509, 0x9a0b9b0c,
    0xf0009809, 0x9003f895, 0xd14d2800, 0x99022001, 0x8f09220a, 0x0e890409, 0xd0074211, 0x67214938,
    0x99046761, 0xd1092920, 0xe0064936, 0x42112211, 0x4935d03a, 0x67616721, 0x67a14934, 0x9a052101,
    0x73512f00, 0x9901d011, 0xd0332900, 0xd02e2f01, 0x02892127, 0x99004308, 0x0a090609, 0x492c4308,
    0x60684308, 0x60a8482b, 0x9800e017, 0xd00f2800, 0x49299a01, 0xd0052a00, 0x1840b2c0, 0x43084927,
    0xe00a6068, 0x1840b2c0, 0x43084925, 0xe00b6068, 0x60684824, 0x28009801, 0x9905d006, 0x73882001,
    0x21406c30, 0x64304308, 0xb00d9803, 0x2126bdf0, 0xe7ce0900, 0xd00c2f01, 0x02892107, 0x99004308,
    0x0a090609, 0x49184308, 0x60684308, 0x60a84817, 0x2106e7ea, 0xe7f00900, 0x00002004, 0x08180402,
    0x00002204, 0x0a20043e, 0x08200401, 0x00000406, 0x24040405, 0x08000400, 0x00012404, 0x8a000400,
    0x06ff06ff, 0x000006ff, 0x06000600, 0x32101e00, 0xb2000200, 0x7c01a604, 0x00040200, 0xa604b000,
    0x26043000, 0x00002404, 0x32000200, 0x7c012604, 0xb08eb570, 0x2100460c, 0x9100910c, 0x910d910b,
    0x9102466a, 0x75114606, 0x71102003, 0x95032501, 0x95094813, 0x900a9208, 0x9504462b, 0x4629aa0a,
    0xf7ff4630, 0xa901fcd7, 0xf7fd4630, 0x2800ffcd, 0x9900d113, 0x401122f7, 0x040a4b0a, 0x910018d3,
    0x742522ff, 0x51133261, 0x220e7525, 0x61a17562, 0x74612104, 0x34c134ff, 0xb00e73e5, 0x0000bd70,
    0x24010485, 0x04000481, 0xb08fb5ff, 0x460c2000, 0x900b900a, 0x900d900c, 0x26016811, 0x2940461d,
    0x7426d318, 0x02496bd1, 0x000b0f49, 0xfe1ff7fd, 0x07041006, 0x1004040c, 0x492c2702, 0x492be002,
    0x39302701, 0xe009910a, 0x27034928, 0xe7f9310a, 0xe0417420, 0x05098829, 0xd03d0f0f, 0x90002000,
    0x90024669, 0x20037508, 0x96037108, 0x23019609, 0xaa0a9108, 0x46199604, 0xf7ff980f, 0xa901fc7b,
    0xf7fd980f, 0x2800ff71, 0x6828d127, 0x0f000100, 0x88a8d005, 0x0e010400, 0x0e00d001, 0x46209000,
    0x74263080, 0xd0052f01, 0xd0082f02, 0xd0162f03, 0xe7cd2000, 0x6401490e, 0x98002140, 0x490de014,
    0x98006401, 0x43082102, 0x90000200, 0x20047526, 0x98007560, 0x746661a0, 0xb0132000, 0x4905bdf0,
    0x6401313d, 0x21809800, 0xe7ee4308, 0x24010435, 0x20010401, 0x20020401, 0x460cb5f7, 0x30c520ff,
    0x59006d09, 0x1a08b098, 0x90012600, 0x74064668, 0x96022501, 0x2c009503, 0x4866d07b, 0xc88d4478,
    0xc18da90d, 0x466a2003, 0xa8097010, 0x20109007, 0x46229008, 0x21013280, 0x98189b03, 0xfc1af7ff,
    0x95024669, 0xf7fd9818, 0x2800ff0f, 0x2001d161, 0x98099011, 0xd1081c40, 0x1c40980a, 0x980bd105,
    0xd1021c40, 0x1c40980c, 0x2210d008, 0xa80da909, 0xff58f7fc, 0xd14c2800, 0xe03a9011, 0x461a2300,
    0x98184621, 0xfbc1f7ff, 0xd1422800, 0x90022009, 0x46692002, 0xa80d7008, 0x27104622, 0x32ff9005,
    0x32119706, 0x9b032101, 0xf7ff9818, 0x4669fbe3, 0x98189502, 0xfed8f7fd, 0xd1742800, 0x461a2300,
    0x98184621, 0xf978f7fe, 0xd16c2800, 0x20039002, 0x70084669, 0x9007a809, 0x98189708, 0xfec4f7fd,
    0xd1602800, 0xa9092210, 0xf7fca80d, 0x2800ff1b, 0x2032d159, 0x20009013, 0x6c209012, 0x43082140,
    0x20466420, 0x25045d01, 0x98182201, 0xfe4af7fd, 0xe048e043, 0x90142000, 0x90169015, 0x21019017,
    0x06096d20, 0xd9014288, 0xe0004823, 0x90144823, 0xb2e84923, 0x49231840, 0x43082301, 0xaa149015,
    0x98182100, 0xfb96f7ff, 0x46692003, 0xa8097008, 0x20109007, 0x98189008, 0xfe86f7fd, 0xd0120007,
    0xd0202e00, 0x6005981a, 0x28009811, 0x4621d008, 0x98189a01, 0xfd0ff7fe, 0x98184607, 0xfdf7f7fd,
    0xd0102e00, 0x2210e010, 0xa80da909, 0xfecaf7fc, 0xd00c2800, 0x2e001c6d, 0x9812d1e4, 0x1c409913,
    0x42889012, 0x4f08d3b6, 0x4638b01b, 0x2601bdf0, 0x0000e7d8, 0x000001d8, 0x8a2004ee, 0x8a1804ed,
    0x00040200, 0xa604b000, 0x00004e8e, 0x08220000, 0x06180816, 0x0612041e, 0x0411060e, 0x0216060c,
    0x06180000, 0x060c0416, 0x0312021e, 0x01210216, 0x0116011a, 0x402a8000, 0x33221100, 0x77665544,
    0xbbaa9988, 0xffeeddcc, 0x0818045a, 0x24ff3008, 0x00000000, 0x00000000, 0x0918055a, 0x25ff3108,
    0x00000000, 0x00000000, 0x0a18065a, 0x26ff3208, 0x00000000, 0x00000000, 0x2403049f, 0x00000000,
    0x00000000, 0x00000000, 0x8760879f, 0xa7048b20, 0x00000000, 0x00000000, 0x0818045a, 0x24ff3008,
    0x00000000, 0x00000000, 0x8b20075a, 0x0000a7ff, 0x00000000, 0x00000000, 0x0818045a, 0x24ff3008,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8a18065a, 0x0000a6ff,
    0x00000000, 0x00000000, 0x8b20075a, 0x0000a7ff, 0x00000000, 0x00000000, 0x00000000, 0x40184000,
    0x40188000, 0x4018c000, 0x40190000, 0x40194000, 0x40198000, 0x4019c000, 0x401a0000, 0x0014ff80,
    0x00160015, 0x00180017, 0x001a0019, 0xffff001b, 0x001c0518, 0x0118000c, 0x03060302, 0x060e051a,
    0x00000000, 0x00000000, 0x00000000, 0x412000d1, 0x60002000, 0x00000000, 0x00000000, 0x60001020,
    0x60001000, 0x00000000, 0x00000000, 0x60000000, 0x00800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00b71b00, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

/**
* List of start and size for each size of flash sector
* The size will apply to all sectors between the listed address and the next address
* in the list.
* The last pair in the list will have sectors starting at that address and ending
* at address start + size.
*/
static const sector_info_t sectors_info[] = {
    {0x60000000, 0x00000400},
 };

static const program_target_t flash = {
    0x200003a9, // Init
    0x20000c9d, // UnInit
    0x2000035d, // EraseChip
    0x20000389, // EraseSector
    0x20000c2d, // ProgramPage
    0x0,        // Verify

    // BKPT : start of blob + 1
    // RSB  : blob start + header + rw data offset
    // RSP  : stack pointer
    {
        0x20000001,
        0x20003480,
        0x20000800
    },

    0x20000000 + 0x00000A00,  // mem buffer location
    0x20000000,               // location to write prog_blob in target RAM
    sizeof(RT1050_IS26KS512S_flash_prog_blob),   // prog_blob size
    RT1050_IS26KS512S_flash_prog_blob,           // address of prog_blob
    0x00000200       // ram_to_flash_bytes_to_be_written
};
