#include "BG96_GNSS.h"

BG96_GNSS::BG96_GNSS()
{
    _bg96_at_handler = CellularContext::get_default_instance()->get_device()->get_at_handler();
    printf("[GPS] Created BG96 Object with AT HANDLER ADDR[%p].\r\n", _bg96_at_handler);
}

uint8_t BG96_GNSS::set_gps_power(bool state)
{
    char _at_cmd[16];
    uint8_t status = SUCCESS;

    sprintf((char *)_at_cmd, "%s", state ? "AT+QGPS=1" : "AT+QGPSEND");
    _bg96_at_handler->lock();
    _bg96_at_handler->cmd_start(_at_cmd);
    _bg96_at_handler->cmd_stop_read_resp();
    if (_bg96_at_handler->get_last_error() != NSAPI_ERROR_OK) {
        printf("[GPS] Failure while trying to change BG96 power.\r\n");
        status = FAILURE;
    } 
    printf("[GPS] Powered ON the GPS module.\r\n");
    _bg96_at_handler->unlock();

    return status;
}

uint8_t BG96_GNSS::get_gps_data(gps_data *data)
{ 
    uint8_t status = SUCCESS;

    _bg96_at_handler->lock();
    _bg96_at_handler->cmd_start("AT+QGPSLOC=2");
    _bg96_at_handler->cmd_stop();

    if (_bg96_at_handler->get_last_error() == NSAPI_ERROR_DEVICE_ERROR) {
        printf("[GPS] Error while trying to get GPS data.\r\n");
        status = FAILURE;
    }
    else {
        _bg96_at_handler->set_stop_tag("OK");
        _bg96_at_handler->resp_start();
        if (_read_gps(data) == FAILURE) {
            printf("[GPS] Error while trying to read GPS data.\r\n");
            printf("[GPS] Ensure that GPS antenna is plugged in.\r\n");
            status = FAILURE;
        }
        _bg96_at_handler->resp_stop();
    }
    _bg96_at_handler->unlock();

    return status;
}

uint8_t BG96_GNSS::_read_gps(gps_data *data)
{
    ssize_t bg96_read_size;
    uint8_t status = SUCCESS;

    bg96_read_size = _bg96_at_handler->read_string(data->utc, sizeof(data->utc)); // header
    if (bg96_read_size == -1) {
        status = FAILURE;
    }
    else {
        // bg96_read_size = _bg96_instance->read_string(data->utc, sizeof(data->utc)); // time
        bg96_read_size = _bg96_at_handler->read_string(data->lat, sizeof(data->lat)); // lat
        bg96_read_size = _bg96_at_handler->read_string(data->lon, sizeof(data->lon)); // lon
        bg96_read_size = _bg96_at_handler->read_string(data->hdop, sizeof(data->hdop)); // hdop
        bg96_read_size = _bg96_at_handler->read_string(data->altitude, sizeof(data->altitude)); // altitude
        bg96_read_size = _bg96_at_handler->read_string(data->fix, sizeof(data->fix)); // fix
        bg96_read_size = _bg96_at_handler->read_string(data->cog, sizeof(data->cog)); // cog
        bg96_read_size = _bg96_at_handler->read_string(data->spkm, sizeof(data->spkm)); // spkm
        bg96_read_size = _bg96_at_handler->read_string(data->spkn, sizeof(data->spkn)); // spkn
        bg96_read_size = _bg96_at_handler->read_string(data->date, sizeof(data->date)); // date
        bg96_read_size = _bg96_at_handler->read_string(data->nsat, sizeof(data->nsat)); // nsat
    }

    return status;
}

void BG96_GNSS::print_gps_data(gps_data *data)
{
    printf("[GPS] Time: \tUTC:%s\r\n", data->utc);
    printf("[GPS] Latitude: \tLAT:%s\r\n", data->lat);
    printf("[GPS] Longitude: \tLON:%s\r\n", data->lon);
    printf("[GPS] Horizontal: \tHDOP:%s\r\n", data->hdop);
    printf("[GPS] Altitude: \tALT:%s\r\n", data->altitude);
    printf("[GPS] Positioning: \tFIX:%s\r\n", data->fix);
    printf("[GPS] Course over time: COG:%s\r\n", data->cog);
    printf("[GPS] Speed km: \tSPKM:%s\r\n", data->spkm);
    printf("[GPS] Speed knots: \tSPKN:%s\r\n", data->spkn);
    printf("[GPS] Date: \t\tDATE:%s\r\n", data->date);
    printf("[GPS] Satelites: \tNSAT:%s\r\n", data->nsat);
}
