#ifndef BG96_GNSS_H
#define BG96_GNSS_H

#include "mbed.h"
#include "CellularNonIPSocket.h"

#define SUCCESS 0
#define FAILURE 1

#define BG96_AT_TIMEOUT      1000
#define BG96_GPS_FIX_TIMEOUT 15000

/* for mode=2 */
typedef struct gps_data_t {
    // char header[9];    // +QGPSLOC:
    char utc[20];      // hhmmss.sss
    char lat[8];       // latitude. (-)dd.ddddd
    char lon[8];       // longitude. (-)dd.ddddd
    char hdop[5];      // Horizontal precision: 0.5-99.9
    char altitude[10];  // altitude of antenna from sea level (meters) 
    char fix[2];       // GNSS position mode 2=2D, 3=3D
    char cog[6];       // Course Over Ground ddd.mm
    char spkm[6];      // Speed over ground (Km/h) xxxx.x
    char spkn[6];      // Speed over ground (knots) xxxx.x
    char date[7];      // data: ddmmyy
    char nsat[2];      // number of satellites 0-12
} gps_data;

class BG96_GNSS 
{
private:
    ATHandler  *_bg96_at_handler; // taken from CellularInterface
    EventQueue *_dummy_eventqueue;
    
    /** Reading GPS from BG96 module using AT commands.
     *
     *  @param  *data   gps data structure for passing data (gps_data)
     *  @return         SUCCESS if data read, FAILURE otherwise
     */
    uint8_t _read_gps(gps_data *data);

public:
    /** Constructor.
     *  Taking CellularInterface default instance.
     */
    BG96_GNSS();

    /** Power ON/OFF GPS module on BG96.
     *  Note: needs to be called before reading GPS data.
     *
     *  @param  *state  true for Power ON, false for Power OFF
     *  @return         SUCCESS if succedded, SUCCESS otherwise
     */
    uint8_t set_gps_power(bool state);
 
    /** Send AT commands to GPS module for GPS data.
     *  Note: Need some time after power ON to fix position.
     *
     *  @param  *data   gps data structure for passing data (gps_data)
     *  @return         SUCCESS if succedded, FAILURE otherwise
     */
    uint8_t get_gps_data(gps_data *data);

    /** Print GPS data structure.
     *
     *  @param  *data   gps data structure for passing data (gps_data)
     */
    void print_gps_data(gps_data *data);


};

#endif /* BG96_GNSS_H */
