/* -----------------------------------------------------------------------------
    Author: Jared McKneely
    Title: End-node firmware v. 1.0.0
    Date: June 8th, 2017
    Description:
    
----------------------------------------------------------------------------- */

// Libraries -------------------------------------------------------------------
#include "mbed.h"
#include "SoftSerial.h"

// Macros ----------------------------------------------------------------------
#define LED_ON  (1)
#define LED_OFF (0)
#define TX (PB_3)
#define RX (PA_10)

// Hardware Objects ------------------------------------------------------------
DigitalOut led(LED1);
InterruptIn button(USER_BUTTON);
InterruptIn receive(PA_10);

// Globals ---------------------------------------------------------------------
SoftSerial xb(TX, RX);
char tx = 'e';
char rx = '0';

// send_light ------------------------------------------------------------------
void send_light(void){
    if (xb.writeable()){
        xb.putc(tx);
    }
}

// blink_light -----------------------------------------------------------------
void blink_light(void){
    led = LED_OFF;
    led = LED_ON;
    wait(0.05);
    led = LED_OFF;
}

// rx_process ------------------------------------------------------------------
void rx_process(void){
    
}

// Main ------------------------------------------------------------------------
int main() {
    
    // Enable interrupt
    button.rise(&send_light);
    receive.rise(&rx_process);
    
    // While loop
    while (true){
        if (xb.readable()){
            rx = xb.getc();
            if (rx == 'e'){
                blink_light();
                rx = '0';
            }
        }
        wait(0.1);
    }
}