#include "mbed.h"
#include "SoftSerial.h"
#include "rtos.h"
#include <sstream>

/* --------- I/O INFORMATION ---------
 USB Debugging Pins: tx = D1(PA2), rx = D0(PA3)
 XBEE Board Pins: 
    DOUT (rx) <- D3 (PB3)
    DIN (tx)  <- D2 (PA10)   
    GND <- GND
    5V <- 5V
    
*/ 

Serial pc(D1, D0); // PA2, PA3

const int nodeID = 0;
//void initialize_node(SoftSerial &xbee);
void initialize_node(SoftSerial &xbee);

int uptime = 0;

int main()
{
    SoftSerial xbee(D3, D2); // tx, rx
    initialize_node(xbee);
    pc.printf("ECHOOOOOO");
    
    char data;
    
    while(true) {
        
        // Continuous transmit
        /*
        std::stringstream s;
        s << 'H' << 'E' << 'L' << 'L' << 'O';
        xbee.printf(s.str().c_str());
        */
        
        //xbee.printf("%d", nodeID);
        xbee.printf("Times Through Loop: %d\n", uptime);
        //pc.printf("%d", nodeID);
        uptime++;
        wait(0.1);
        
        //Requested transmit
        if(xbee.readable()) {
            data = xbee.getc();
            if(data == 'p'){
                xbee.printf("%d", nodeID);
            } else if (data == 'u') {
                xbee.printf("uptime = %d\n", uptime);
            }
        }
        
    }
}

// Change back to SoftSerial
void initialize_node(SoftSerial &xbee){
    // Eventually put stuff here. 
}

/*
int main(){
    pc.printf("Echoes back to the screen anything you type\n");
    while(1){
        if(pc.readable()){
            pc.putc(pc.getc()+1);
            pc.printf("\n");
        }
        
        wait(0.1);
        pc.printf("E");
    }
} 
*/









