/*
    Author: Jonathan Yost
    Title: END_NODE_REQUEST_POC
    Date: 6/28/17
    
    Desc: Reads in data from the sensors and sends to the gateway.
    yeah.
*/

// ISSUES
/*  TODO!!! SOMETIMES THE XBEE READS IN "i:1" instead of "id:1"...
    No idea why. For now I will accept both, but that's gross.         
*/

// Libraries
#include "mbed.h"
#include "BME280.h"
#include "SI1145.h"

// Define Constants / Macros
#define node_id (0x01)
#define tx (PA_9)
#define rx (PA_10)

const char nodeID = '1';

// I/O Delarations
I2C i2c(I2C_SDA, I2C_SCL); // D14, D15
BME280 *thp_sensor = new BME280(i2c);
SI1145 *uiv_sensor = new SI1145(i2c);

// Declare the PIR interface
InterruptIn MotionDetect(PA_0);
bool pir_enable = true;
bool pir_trigger = false;

// Declare Serial Interfaces
Serial xb(tx, rx);
Serial pc(D1, D0);

// send_sensor_data(temp, pressure, humidity, motion, uv, ir, vis, noise);
// "id:2,te:2,pr:3,mo:4,uv:5,ir:6,vi:7,no:8"
void SendSensorData(int t, int p, int h, int u, int ir, int v, int n){
    //"               ni:XX, te:XX,pr:XX,hu:XX,uv:XX,ir:XX,vi:XX,no:XX"
    xb.printf(      ",ni:%d,te:%d,pr:%d,hu:%d,uv:%d,ir:%d,vi:%d,no:%d\n\r",1,t,p,h,u,ir,v,n);
    pc.printf("send:  ni:%d,te:%d,pr:%d,hu:%d,uv:%d,ir:%d,vi:%d,no:%d\n\r",1,t,p,h,u,ir,v,n);
}

void SendPirFlag(){
    if(xb.writeable() && pir_enable){
        pir_trigger = false;
        xb.printf("ni:%c,mo:1\r\n",nodeID);
        pc.printf("ni:%c,mo:1\r\n",nodeID);
    }
}

// PIR interrupt. Set the pir_trigger to true when interrupted.
void PIR(void){
    pir_trigger = true;
    if(pir_enable){
        SendPirFlag();
        pc.printf("PIR FLAG ISR\r\n");
    }
}

void initialize_serial_connections(){
    xb.baud(57600);
    pc.baud(115200);   
}

int main() {
    initialize_serial_connections();
    
    pc.printf("\n\rMic test 1-2, 1-2\n\r");
    
    // Attach the PIR function to interrupt
    MotionDetect.rise(&PIR);
    
    char pc_data = 'e';
    char buffer[10];
        
    int temp = 1;
    int pressure = 2;
    int humidity = 3;
    int uv = 5;
    int ir = 6;
    int vis = 7;
    int noise = 8;
    
    bool send_enable = false;
            
    while(true){
        // Debug Controls Input
        if(pc.readable()){
            pc_data = pc.getc();
            pc.printf("%c", pc_data);
            if(xb.writeable()){xb.printf("%c", pc_data);}
        }
        
        if(pir_enable && pir_trigger){
            SendPirFlag();
        }
        
        if(xb.readable()){
            wait(0.01);
            for(int i = 0; i < sizeof(buffer); i++){
                buffer[i] = xb.getc();
            }
            pc.printf("=========================================\r\n");
            // Print out received message in char and int format 
            if(buffer[4] == nodeID){
                send_enable = true;
                pc.printf("RECV: ");
                // Print out message (CHAR)
                for(int i = 1; i < sizeof(buffer); i++){
                    pc.printf("%c", buffer[i]);
                }
                pc.printf("\r\nRECV: ");
                // Print out message (INT)
                for(int i = 0; i < sizeof(buffer); i++){
                    pc.printf("%i,", buffer[i]);
                }
                pc.printf("\r\n");
            } else {
                pc.printf("Ignore, Target Node: #%c\r\n", buffer[4]);
                pc.printf("%s\r\n",buffer);
            }
            
            if(buffer[9] == '1'){
                pir_enable = true;
                pc.printf("pir_enable = true\r\n");
            } else if (buffer[9] == '0'){
                pir_enable = false;
                pc.printf("pir_enable = false\r\n");
            }
            memset(buffer, '\0', sizeof(buffer));
        }
        
        // Take in new measurements
        // Read in values from the BME280 board
        temp = thp_sensor->getTemperature();
        pressure = thp_sensor->getPressure();
        humidity = thp_sensor->getHumidity();
        
        //Sensor data from the SI1145 board
        uv = uiv_sensor->getUV(); // Reads from the SI1145 
        ir = uiv_sensor->getIR(); // Reads from the SI1145
        vis = uiv_sensor->getVIS(); // Reads from the SI1145
        
        noise = 404;
        
        // Transmit over the xbee if possible and necessary
        if(xb.writeable() && send_enable){
            SendSensorData(temp, pressure, humidity, uv, ir, vis, noise);
            send_enable = false;
        }
        
    }
}

