/*
    Author: Jonathan Yost
    Title: END_NODE_REQUEST_POC
    Date: 6/28/17
    
    Desc: Reads in data from the sensors and sends to the gateway.
    yeah.
*/

// Libraries
#include "mbed.h" 
#include "BME280.h"
#include "SI1145.h"

// Define Constants / Macros
#define node_id (0x01)
#define tx (PA_9)
#define rx (PA_10)

// Declare Noise Sensor Stuff
#define noise_pin (PA_1)

const char nodeID = '1';

// RX declarations
uint8_t rx_buffer[128];
bool rx_flag = false;
int rx_index = 0;


// I/O Delarations
I2C i2c(I2C_SDA, I2C_SCL); // D4, D5 
BME280 *thp_sensor = new BME280(i2c);
SI1145 *uiv_sensor = new SI1145(i2c);
AnalogIn adc_noise(noise_pin);


// Declare the PIR interface
InterruptIn PIR_sensor(PB_5);
Ticker pir_timer;
Ticker pir_send_timer;
bool pir_enable = false;
bool pir_trigger = false;

Ticker reset_timer;

// Declare Serial Interfaces
Serial xb(tx, rx); // Serial 1
Serial pc(PB_3, PB_4); // Serial 2

// send_sensor_data(temp, pressure, humidity, motion, uv, ir, vis, noise);
void SendSensorData(int t, int p, int h, int u, int ir, int v, int n){
    //"               ni:XX, te:XX,pr:XX,hu:XX,uv:XX,ir:XX,vi:XX,no:XX"
    xb.printf(      ",ni:%c,te:%d,pr:%d,hu:%d,uv:%d,ir:%d,vi:%d,no:%d\n\r",nodeID,t,p,h,u,ir,v,n);
    pc.printf("  >> ,ni:%c,te:%d,pr:%d,hu:%d,uv:%d,ir:%d,vi:%d,no:%d\n\r",nodeID,t,p,h,u,ir,v,n);
}

void SendPirFlag(){
    if(xb.writeable() && pir_enable){  
        xb.printf("ni:%c,mo:1\r\n",nodeID);
        pc.printf("  >> ni:%c,mo:1\r\n",nodeID);
        pir_trigger = false;
    }
}

// PIR interrupt. Set the pir_trigger to true when interrupted.
void PIR(void){
    /*
    if(PIR_sensor.read()){
        pc.printf("# \r\n");
        pir_trigger = true;
    }*/
    
    
    if(PIR_sensor.read() && !pir_trigger){
        pc.printf("# \r\n");
        pir_trigger = true;
    }
    
}

// This method is attached to a timer
void PIR_timed_send(){
    if(pir_trigger){
        SendPirFlag();
    }
}

void initialize_serial_connections(){
    xb.baud(57600);
    pc.baud(115200);   
}

void rx_read_callback(){
    char c = xb.getc();
    //pc.printf("%c", c);
    
    if(c == '\n'){
        rx_flag = true;
        rx_index = 0;
        pc.printf("                                \r\n");
    } else {    
        rx_buffer[rx_index] = c;
        rx_index++;
    }
    
    if(rx_index > 127){
        rx_index = 0;
    }   
}

void system_reset() {
    NVIC_SystemReset();
    }

int main() {
    initialize_serial_connections();
    memset(rx_buffer, '\0', 128);
    pc.printf("\n\rMic test 1-2, 1-2\n\r");
    pc.printf("NODE ID: %c\n\r", nodeID);
    
    xb.attach(&rx_read_callback, Serial::RxIrq);
    
    // Attach the PIR function to ticker thing
    pir_timer.attach(&PIR, 0.2);
    pir_send_timer.attach(&PIR_timed_send, 1.5);
    reset_timer.attach(&system_reset, 169);
    
     
    char pc_data = 'e';
        
    int temp = 1;
    int pressure = 2;
    int humidity = 3;
    int uv = 5;
    int ir = 6;
    int vis = 7;
    int noise = 8;
    
    bool send_enable = false;
            
    while(true){
        //pc.printf("top of loop \r\n");
        
        // Debug Controls Input
        if(pc.readable()){
            pc_data = pc.getc();
            pc.printf("%c", pc_data);
            if(xb.writeable()){xb.printf("%c", pc_data);}
        }
        
        // Read in values from the BME280 board
        temp = thp_sensor->getTemperature();
        pressure = thp_sensor->getPressure();
        humidity = thp_sensor->getHumidity();
        
        //Sensor data from the SI1145 board
        uv = uiv_sensor->getUV(); // Reads from the SI1145
        ir = uiv_sensor->getIR(); // Reads from the SI1145
        vis = uiv_sensor->getVIS(); // Reads from the SI1145

        noise = adc_noise.read();
        
        if(rx_flag){
            //pc.printf("IND:  0123456789ABCDEF\r\n"); // Show indices
            pc.printf("<<   %s\r\n", rx_buffer); // Show received message
            rx_flag = false;
            
            if(rx_buffer[3] == nodeID){
                send_enable = true;
            } else {
                //pc.printf("Target: NODE %c\r\n", rx_buffer[3]);
            }
            
            if(rx_buffer[5] == 'm' && rx_buffer[6] == 's'){
                send_enable = false;
                if(rx_buffer[8] == '1'){
                    pir_enable = true;
                    pc.printf("PIR on\r\n");
                } else {
                    pir_enable = false;
                    pc.printf("PIR off\r\n");
                }
            }
            memset(rx_buffer, '\0', sizeof(rx_buffer));
        }
        
        // Transmit over the xbee if possible and necessary
        if(xb.writeable() && send_enable) {
            
            SendSensorData(temp, pressure, humidity, uv, ir, vis, noise);
            send_enable = false;
        }
        
        //pc.printf("bottom of loop \r\n");
    }
}

