#include "mbed.h"

// Button A is on P0 bit 17 
// Pin labelled "0" on edge connector is in fact connected to P0_3 
volatile uint32_t * P0OUT = (uint32_t *)0x50000504;
volatile uint32_t * P0DIR = (uint32_t *)0x50000514;
void dly(volatile uint32_t len)
{
    // "volatile" modifier is necessary here 
    // to prevent the compiler from optimizing 
    // this software delay to nothing
    while(len--);
}
int main() {
    
    *P0DIR = (1 << 3);    // Make P0 Bit 3 (labelled 0 on breakout board) an output
    while(1) {                  
        *P0OUT = (1 << 3); // Make P0 Bit 3 a '1' (turns on the LED)    
        dly(1000000);      // wait a while
        *P0OUT = 0;        // LED off
        dly(1000000);      // Wait a while
    }
}
