#include "mbed.h"

BusOut Digits(dp27,dp26,dp25,dp24);
BusOut Segments(dp5,dp6,dp28,dp1,dp2,dp17,dp4);
//d4,dp17,dp2,dp1,dp28,dp6,dp5);
#define SEG_A 1
#define SEG_B 2
#define SEG_C 4
#define SEG_D 8
#define SEG_E 16
#define SEG_F 32
#define SEG_G 64

const short patterns[]={                                                                                      \
                      SEG_A | SEG_B | SEG_C | SEG_D | SEG_E | SEG_F        ,\
                      SEG_B | SEG_C                                ,        \
                      SEG_A | SEG_B |         SEG_D | SEG_E |         SEG_G,\
                      SEG_A | SEG_B | SEG_C | SEG_D |                   SEG_G,\
                              SEG_B | SEG_C |                 SEG_F | SEG_G,\
                      SEG_A |         SEG_C | SEG_D |         SEG_F | SEG_G,\
                      SEG_A |         SEG_C | SEG_D | SEG_E | SEG_F | SEG_G,\
                      SEG_A | SEG_B | SEG_C                                ,\
                      SEG_A | SEG_B | SEG_C | SEG_D | SEG_E | SEG_F | SEG_G,\
                      SEG_A | SEG_B | SEG_C | SEG_D |         SEG_F | SEG_G \
      
                      };
                      
void DisplayNumber(int Number)
{
    Digits=0xe;
    Segments=patterns[Number % 10];
    Number = Number / 10;
    wait_ms(5);
    Digits=0xd;
    Segments=patterns[Number % 10];
    Number = Number / 10;
    wait_ms(5);
    Digits=0xb;
    Segments=patterns[Number % 10];
    Number = Number / 10;
    wait_ms(5);
    Digits=0x7;
    Segments=patterns[Number % 10];   
    wait_ms(5);
}
                      
int main() {
    int Counter=0;
    while(1) {
       DisplayNumber(Counter++);
       
    }
}
