#include "mbed.h"
#include <stm32l432xx.h>


#define PWM_PERIOD_COUNT 1000

/*
For register definitions see here:
https://github.com/ARMmbed/mbed-os/blob/master/targets/TARGET_STM/TARGET_STM32L4/TARGET_STM32L432xC/device/stm32l432xx.h
*/

// Using the MBED libraries to configure the PWM outputs (its easier than 
// calculating all of the register contents by hand)
DigitalOut myled(LED1);
PwmOut  PhaATop(PA_8); 
PwmOut  PhaABottom(PA_7);
void initTimer1()
{    
    
    TIM1->CR1 = 0; // make sure Counter is disabled before changing configuration
    TIM1->CR2 = 0;
    TIM1->PSC = 1;
    TIM1->ARR = PWM_PERIOD_COUNT;
    TIM1->CCR1 = PWM_PERIOD_COUNT/4; // 25% duty
    // Enable channel 1 and its complimentary output
    TIM1->CCER = (1 << 0) + (1 << 2);
    TIM1->SR = 0;      // Clear flags.    
    TIM1->CR1 |= 1; // enable counter

}

int main() {    
   
    initTimer1();
    while(1) {
       
    }
}
