#include "mbed.h"
#include <stm32l432xx.h>


#define PWM_PERIOD_COUNT 1000

/*
For register definitions see here:
https://github.com/ARMmbed/mbed-os/blob/master/targets/TARGET_STM/TARGET_STM32L4/TARGET_STM32L432xC/device/stm32l432xx.h
*/
// Using the MBED libraries to configure the PWM outputs (its easier than 
// calculating all of the register contents by hand)
DigitalOut myled(LED1);
PwmOut  PhaATop(PA_8); 
PwmOut  PhaBTop(PA_9); 
PwmOut  PhaCTop(PA_10); 
PwmOut  PhaABottom(PA_7); 
PwmOut  PhaBBottom(PB_0); 
PwmOut  PhaCBottom(PB_1); 

void initTimer1()
{    
    
    TIM1->CR1 = 0; // make sure Counter is disabled before changing configuration
    TIM1->CR2 = 0;
    TIM1->PSC = 1;
    TIM1->ARR = PWM_PERIOD_COUNT;
    TIM1->CCR1 = PWM_PERIOD_COUNT/4; // 25% duty
    TIM1->CCR2 = PWM_PERIOD_COUNT/2; // 50% duty
    TIM1->CCR3 = 3*PWM_PERIOD_COUNT/4; // 75% duty
    // Enable complimentary outputs on channels 1 to 3
    TIM1->CCER = (1 << 0) + (1 << 2) + (1 << 4) + (1 << 6) + (1 << 8) + (1<<10);
    TIM1->SR = 0;      // Clear flags.    
    TIM1->BDTR &= ~(0xff);
    TIM1->BDTR |= (127); // set dead time to 127 clock cycles
    

}

int main() {    
   
    initTimer1();
    while(1) {
       
    }
}
