#include "LCD.h"

DigitalOut RS(A4);             // RS
DigitalOut RW(A3);             // RW
DigitalOut E(A5);              // Enable
//BusOut data (D2, D3, D4, D5);// DB4-DB7
BusOut data (D5, D4, D3, D2);// DB4-DB7

/****initialise LCD function ****/  
void LCD_init(void){  

  RS=0;    // set all low to write control/instruction data
//  RW=0;
  E=1;
  
  wait_ms(20);
    data=0x3;            // for our display see ted
  toggle_enable();
  wait_ms(5); // must be more than 4.1ms
   data=0x3;            // for our display see ted
  toggle_enable();
  wait_ms(1); // must be more than 100us
   data=0x3;            // for our display see ted
  toggle_enable();
  wait_ms(5); //
   data=0x2;            // = 4 bit mode
  toggle_enable();
     
  // Function set
  // N=0 : 2 lines (half lines!), F=0 : 5x7 font
  data=0x2;            // = 4 bit mode
  toggle_enable();
  data=0x8;            // = 2-line mode, 7 dot characters
  toggle_enable(); 
 
  // Display Mode
  // Display: display off, cursor off, blink off
  data=0x0;          //                    
  toggle_enable();
  data=0x8;                               
  toggle_enable();
// Clear display
 data=0x0;          //                    
  toggle_enable();
  data=0x1;                         
  toggle_enable();
 // Set entry mode: ID=1, S=0
 data=0x0;          //                    
  toggle_enable();
  data=0x6;                               
  toggle_enable();
 // Display: display on, cursor on, blink on    
   data=0x0;          
  toggle_enable();
  data=0xF;                               
  toggle_enable();


  /*// Clear display
  data=0x0;            //
  toggle_enable();
  data=0x1;            // clear 
  toggle_enable();*/
  
}


/**** display ****/  
void display_to_LCD(char value ){
    
    RS=1;
    //***** display character *****************            
    data=value>>4;       // value shifted right 4 = upper              
    toggle_enable();
    data=value&0x0F;       // value bitmask with 0x0F = lower      
    toggle_enable();
}

/**** display ****/  
void send_command_to_LCD(char value ){
    
    RS=0;
    //***** display character *****************            
    data=value>>4;       // value shifted right 4 = upper              
    toggle_enable();
    data=value&0x0F;       // value bitmask with 0x0F = lower      
    toggle_enable();
}


/**** toggle enable function ****/  
void toggle_enable(void){
  wait(0.001);
  E=0;
  wait(0.001);
  E=1;
  wait(0.002);
}

/**** set location function ****/                                                                      
void set_location(char location){
    RS=0;
    data=(location|0x80)>>4;             // upper nibble             
    toggle_enable();
    data=location&0x0F;                  // lower nibble      
    toggle_enable();
}
