#include "mbed.h"
DigitalOut  my_led(LED1);

/*
Pin mappings for Timer 1 (the advanced timer with deadtime)
From: https://developer.mbed.org/users/mbed_official/code/mbed-src/file/a11c0372f0ba/targets/hal/TARGET_STM/TARGET_STM32F1/TARGET_NUCLEO_F103RB/PeripheralPins.c
    {PA_8,  PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH1 - Default
    {PA_9,  PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH2 - Default
    {PA_10, PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH3 - Default
    {PB_13, PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH1N - Default
    {PB_14, PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH2N - Default
    {PB_15, PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH3N - Default
 
*/

int main()
{

    PwmOut      PhaATop(PA_8);    
    PwmOut      PhaABtm(PB_13);  // This should be the complement of PA_8    
    PhaATop.period_ms(1);
    PhaATop = 0.8;          
    TIM1->CCER |= 4; //enable complimentary output
    TIM1->BDTR |= 0xff; // specify the maximum amount of deadtime required approx 13.5us - see page 356 of reference manual
    while (1) {
        my_led = !my_led;
        wait(0.2); // 500 ms
    }
}
