#include "mbed.h"
DigitalOut  my_led(LED1);
AnalogIn Pot(A0);
/*
Pin mappings for Timer 1 (the advanced timer with deadtime)
From: https://developer.mbed.org/users/mbed_official/code/mbed-src/file/a11c0372f0ba/targets/hal/TARGET_STM/TARGET_STM32F1/TARGET_NUCLEO_F103RB/PeripheralPins.c
    {PA_8,  PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH1 - Default
    {PA_9,  PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH2 - Default
    {PA_10, PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH3 - Default
    {PB_13, PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH1N - Default
    {PB_14, PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH2N - Default
    {PB_15, PWM_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, 0)}, // TIM1_CH3N - Default
 
*/
void init(void);
void SetDuty(float Duty);
int main()
{
    float Duty = 0.1;
    init();
    SetDuty(Duty);   
    while (1) {
        my_led = !my_led;
        wait(0.2); // 500 ms//
        Duty = Pot.read();        
        SetDuty(Duty);
    }
}
PwmOut      PhaATop(PA_8);    
PwmOut      PhaABtm(PB_13);  // This should be the complement of PA_8    
PwmOut      PhaBBtm(PA_9);    
PwmOut      PhaBTop(PB_14);  // This should be the complement of PA_9   

void init()
{        
    PhaATop.period_ms(10);
    PhaATop = 0.4;  
    PhaBBtm.period_ms(10);
    PhaBBtm = 1-0.4;             
    TIM1->CCER |= 4; //enable ch1 complimentary output    
    TIM1->CCER |= 64; //enable ch2 complimentary output
    TIM1->CR1 |= (1<<6); // enable centre aligned mode
    TIM1->CR1 &= ~(1<<4); // enable centre aligned mode 
}
void SetDuty(float Duty)
{   
    Duty = Duty / 2.0;
    PhaATop = Duty;      
    PhaBBtm = 1.0-Duty;  
    TIM1->CCER |= 4; //enable ch1 complimentary output   -> Write operation blows these bits away
    TIM1->CCER |= 64; //enable ch2 complimentary output  -> Write operation blows these bits away
}