#include "mbed.h"
/* 
 * All the LEDs on the micro:bit are part of the LED Matrix,
 * In order to get simple blinking behaviour, we set column 0
 * to be permanently at ground. If you want to use the LEDs as
 * a screen, there is a display driver in the micro:bit 'DAL',
 */
// Columns are active low
// Rows are active high 
// Initialize all LED matrix connections in an inactive state
DigitalOut col1(P0_4,1);
DigitalOut col2(P0_5,1);
DigitalOut col3(P0_6,1);
DigitalOut col4(P0_7,1);
DigitalOut col5(P0_8,1);
DigitalOut col6(P0_9,1);
DigitalOut col7(P0_10,1);
DigitalOut col8(P0_11,1);
DigitalOut col9(P0_12,1);
DigitalOut row1(P0_13,0);
DigitalOut row2(P0_14,0);
DigitalOut row3(P0_15,0);



Ticker DisplayThreadObject;
typedef struct  {
    DigitalOut & row;
    DigitalOut & col;
    int state;  
} LEDStruct;
LEDStruct FrameBuffer[5][5] = { {{row1,col1,0}, {row2,col4,0}, {row1,col2,0}, {row2,col5,0}, {row1,col3,0}},
                                {{row3,col4,0}, {row3,col5,0}, {row3,col6,0}, {row3,col7,0}, {row3,col8,0}}, 
                                {{row2,col2,0}, {row1,col9,0}, {row2,col3,0}, {row3,col9,0}, {row2,col1,0}}, 
                                {{row1,col8,0}, {row1,col7,0}, {row1,col6,0}, {row1,col5,0}, {row1,col4,0}}, 
                                {{row3,col3,0}, {row2,col7,0}, {row3,col1,0}, {row2,col6,0}, {row3,col2,0}} 
                            };


void DisplayThreadTask(void)
{
    static int row=0;
    static int col=0;

    // Turn off all LEDs from previous state
    for (int row=0;row<5;row++)
    {
        for (int col=0;col<5;col++)
        {
            FrameBuffer[row][col].row=0;            
            FrameBuffer[row][col].col=1;
        }
    }
    
    if (FrameBuffer[row][col].state==1)
    {
        // Turn LED on
        FrameBuffer[row][col].row = 1;
        FrameBuffer[row][col].col = 0;
    }
    else
    {
        // Turn LED off
        FrameBuffer[row][col].row = 0;
        FrameBuffer[row][col].col = 1;
    }
    
    col++;
    if (col > 4)
    {
        col = 0;
        row ++ ;
        if (row > 4)
            row = 0;
    }
    
}
int main() {
    
    DisplayThreadObject.attach(DisplayThreadTask,0.001); // update the display once LED per millisecond

    FrameBuffer[0][0].state = 1;
    FrameBuffer[0][1].state = 1;
    FrameBuffer[0][2].state = 1;
    FrameBuffer[0][3].state = 1;
    FrameBuffer[0][4].state = 1;
    
    FrameBuffer[2][2].state = 1;
    
    FrameBuffer[4][0].state = 1;
    FrameBuffer[4][1].state = 1;
    FrameBuffer[4][2].state = 1;
    FrameBuffer[4][3].state = 1;
    FrameBuffer[4][4].state = 1;
    

    while(1) {
        
    }
}
