//BLEservice.h
#ifndef __BLESERVICE_H
#define __BLESERVICE_H
#define MAX_CHARACTERISTICS 16
extern Serial pc;
typedef void (*fptr)(void);

class BLEservice {
public:
    uint16_t Service_UUID; 
    uint32_t Characteristic_Count;
    uint16_t Characteristic_UUID_Array[MAX_CHARACTERISTICS]; // This will contain the list of characterisic UUID's
    BLEservice(BLEDevice &_ble,uint16_t Service_UUID,uint32_t Characteristic_Count, uint16_t *Characteristic_UUID_Array, fptr init, fptr poll,int Notify=0): ble(_ble)
    {
        
        pc.printf("Entering constructor\r\n");
        this->Service_UUID = Service_UUID;
        this->Characteristic_Count = Characteristic_Count;
        pc.printf("Array of %d chars created\r\n",Characteristic_Count);
        for (int i=0;i<Characteristic_Count;i++)
        {
            pc.printf("UUID %d = %d\r\n",i,Characteristic_UUID_Array[i]);
            printf("Address of Characteristic_UUID_Array = %p\r\n",this->Characteristic_UUID_Array);
            this->Characteristic_UUID_Array[i]=Characteristic_UUID_Array[i];
        }
        pc.printf("chars copied\r\n");
        this->init = init;
        this->poll = poll;
        Value = 0;        
        GattCharacteristic *charTable[MAX_CHARACTERISTICS];
        for (int i=0; i < Characteristic_Count; i++)
        {
            if (Notify == 1)
            {
                Characteristics[i] = new ReadWriteGattCharacteristic<uint16_t>(this->Characteristic_UUID_Array[i],&Value,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);  
            }
            else
            {
                Characteristics[i] = new ReadWriteGattCharacteristic<uint16_t>(this->Characteristic_UUID_Array[i],&Value);  
            }
            charTable[i] = Characteristics[i];
            printf("Characteristic %d added\r\n",this->Characteristic_UUID_Array[i]);
        }
        GattService   Service(this->Service_UUID, charTable, Characteristic_Count);
        pc.printf("Service created\r\n");
        ble.addService(Service);
        pc.printf("Service added\r\n");
    }            
    ~BLEservice()
    {
        
    }
    fptr init;
    fptr poll;            
    uint16_t readCharacteristic(uint16_t index)
    {
        uint16_t Value,Len;
        Len = sizeof(Value);
        ble.gattServer().read(this->Characteristics[index]->getValueHandle(),(uint8_t *)&Value,&Len); 
        return Value;
    }
    void writeCharacteristic(uint16_t index, uint16_t Value)
    {
         pc.printf("Writing %d to handle %d\r\n",Value,this->Characteristics[index]->getValueHandle());
         
         ble.gattServer().write(this->Characteristics[index]->getValueHandle(),(uint8_t *)&Value,sizeof(uint16_t)); 
    }
    BLEDevice &ble; // Keep track of the Bluetoot device we are attached to.
    ReadWriteGattCharacteristic<uint16_t> * Characteristics[MAX_CHARACTERISTICS];
    uint16_t Value;
};
#endif
