#include "mbed.h"
#include "pwm.h"
DigitalOut myled(LED1);
/*
PA8,9,10 are used to drive the PWM outputs.  They are also connected back to TIM_CH1,CH2,CH3 
EN1,2,3 are pulled low and connected back to PC10,11,12
PC13 = Blue button
PB13 = User LED (I think - if not it is PA5)
*/


PwmOut PhA(PA_8);
PwmOut PhB(PA_9);
PwmOut PhC(PA_10);


DigitalOut En1(PC_10);
DigitalOut En2(PC_11);
DigitalOut En3(PC_12);
Serial pc(USBTX, USBRX); // tx, rx useful for debugging
volatile int CountA,CountB,CountC;

void TimerISR(void)
{
    TIM1->CCR1 = PWM[CountA]; 
    TIM1->CCR2 = PWM[CountB]; 
    TIM1->CCR3 = PWM[CountC]; 
    CountA = (CountA + 1) % PWM_LENGTH;
    CountB = (CountB + 1) % PWM_LENGTH;
    CountC = (CountC + 1) % PWM_LENGTH;
    TIM1->SR &= ~0x3f; // ack the interrupt    

}
void initTimer1()
{    
    
    TIM1->CR1 = 0; // make sure Counter is disabled before changing configuration
    TIM1->CR2 = 0;
    TIM1->PSC = 0;
    TIM1->ARR = (PWM[0]*2)-1;
    TIM1->CCR1 = 0; // 0% duty
    TIM1->CCR2 = 0; // 0% duty
    TIM1->CCR3 = 0; // 0% duty
    // Enable timer outputs on channels 1,2,3
    TIM1->CCER = (1 << 0) + (1 << 4) + (1 << 8);
    TIM1->SR = 0;      // Clear flags.    
    TIM1->CR1 |= 1; // enable counter

    // Set up the interrupt handler
    TIM1->DIER = 1; // Want update interrupt
    NVIC_SetVector(TIM1_UP_TIM16_IRQn,(uint32_t) TimerISR);   
    NVIC_EnableIRQ(TIM1_UP_TIM16_IRQn);
    __enable_irq();   // enable interrupts */

}
void start()
{
    
    TIM1->CCR1 = 0; // 0% duty
    TIM1->CCR2 = 0; // 0% duty
    TIM1->CCR3 = 0; // 0% duty
    En1 = 1;
    En2 = 1;
    En3 = 1;
    CountA = 0;
    CountB = PWM_LENGTH / 3;
    CountC = (2 *PWM_LENGTH) / 3;
}
int main() {
    initTimer1();
    start();
    while(1) {
        wait(0.1);
            myled = myled ^ 1;
    }
}
