#ifndef __BUTTONA_SERVICE_H__
#define __BUTTONA_SERVICE_H__
// Button A is on P0 bit 17 
volatile uint32_t * P0OUT = (uint32_t *)0x50000504;
volatile uint32_t * P0DIR = (uint32_t *)0x50000514;
volatile uint32_t * P0IN  = (uint32_t *)0x50000510;
volatile uint32_t * P0CONF  = (uint32_t *)(0x50000700);
int8_t initialValue=0;
class ButtonAService {
public:
    const static uint16_t BUTTONA_SERVICE_UUID              = 0x1eee;
    const static uint16_t BUTTONA_STATE_CHARACTERISTIC_UUID = 0x2019;

    ButtonAService(BLEDevice &_ble) :
        ble(_ble), ButtonState(BUTTONA_STATE_CHARACTERISTIC_UUID,&initialValue,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&ButtonState};
        GattService         btnService(BUTTONA_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(btnService);
        P0CONF[17] = 0;  // On power up, input buffer is not connected so must do this
        PreviousButtonState = -1;
    }

    GattAttribute::Handle_t getValueHandle() const {
        return ButtonState.getValueHandle();
    }
    void poll() {
        uint8_t newValue = GetButtonAState();
        if (newValue != PreviousButtonState)
        {   
            // only send an update if the button state has changed (reduces traffic)
            ble.gattServer().write(this->getValueHandle(), (uint8_t *)&newValue, sizeof(uint8_t));        
            PreviousButtonState = newValue;
        }
    }
    uint8_t GetButtonAState()
    {
        if ((*P0IN & (1 << 17))==0)    
            return 1;
        else
            return 0;
    }

private:
    BLEDevice  &ble;
    ReadOnlyGattCharacteristic<int8_t>  ButtonState;
    uint8_t PreviousButtonState;
    
};

#endif
