/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_ACCEL_SERVICE_H__
#define __BLE_ACCEL_SERVICE_H__
#include <mbed.h>
// Accelerometer : LSM303
I2C i2c(P0_30, P0_0); // SDA is on P0_30, SCL is on P0_0
const int LSM303_ADDRESS = (0x19<<1); 
//const int MMA8653_ID = 0x5a;
class ACCELService {
public:
    const static uint16_t ACCEL_SERVICE_UUID = 0xA012;
    const static uint16_t ACCEL_X_CHARACTERISTIC_UUID = 0xA013;
    const static uint16_t ACCEL_Y_CHARACTERISTIC_UUID = 0xA014;
    const static uint16_t ACCEL_Z_CHARACTERISTIC_UUID = 0xA015;

    ACCELService(BLEDevice &_ble, int16_t initialValueForACCELCharacteristic) :
        ble(_ble), AccelX(ACCEL_X_CHARACTERISTIC_UUID, &initialValueForACCELCharacteristic),AccelY(ACCEL_Y_CHARACTERISTIC_UUID, &initialValueForACCELCharacteristic),AccelZ(ACCEL_Z_CHARACTERISTIC_UUID, &initialValueForACCELCharacteristic)
    {
        GattCharacteristic *charTable[] = {&AccelX,&AccelY,&AccelZ};
        GattService         AccelService(ACCEL_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(AccelService);
        // Wake the accelerometer from sleep mode by writing disabling low power mode, setting freq to 10Hz and enabling all three axes
        char Data[8]; // Declare a buffer for data transfer    
        int Status;
        Data[0]=0x20;   // wake up LSM303 (max speed, all accel channels)
        Data[1]=0x77;
        Status = i2c.write(LSM303_ADDRESS,Data,2);  // Write data to register   
       
        Data[0]=0x23;   // enable high resolution mode
        Data[1]=0x0e; 
        Status = i2c.write(LSM303_ADDRESS,Data,2);  // Write data to register   
    }

    GattAttribute::Handle_t getValueHandle() const {
        return AccelX.getValueHandle();
    }
    void updateAccelX(uint16_t newValue) {
        ble.gattServer().write(AccelX.getValueHandle(), (uint8_t *)&newValue, sizeof(uint16_t));
    }
    void updateAccelY(uint16_t newValue) {
        ble.gattServer().write(AccelY.getValueHandle(), (uint8_t *)&newValue, sizeof(uint16_t));
    }
    void updateAccelZ(uint16_t newValue) {
        ble.gattServer().write(AccelZ.getValueHandle(), (uint8_t *)&newValue, sizeof(uint16_t));
    }
    void poll()
    {
        char Data[8]; // Declare a buffer for data transfer    
        int Status;
        int16_t X;
                         
        
        Data[0]=0x80 + 0x28; // Register number 0x28 has the X data (2 bytes)
        Status = i2c.write(LSM303_ADDRESS,Data,1,true);  // Write register number
        Status = i2c.read(LSM303_ADDRESS,Data,2); // Read register contents
        X = Data[1];
        X = (X << 8) + Data[0];
        
        int16_t Y;
        Data[0]=0x80 + 0x2a; // Register number 0x2a has the Y data (2 bytes)
        Status = i2c.write(LSM303_ADDRESS,Data,1,true);  // Write register number
        Status = i2c.read(LSM303_ADDRESS,Data,2); // Read register contents
        Y = Data[1];
        Y = (Y << 8) + Data[0];
        
        int16_t Z;
        Data[0]=0x80 + 0x2c; // Register number 0x2c has the Z data (2 bytes)
        Status = i2c.write(LSM303_ADDRESS,Data,1,true);  // Write register number
        Status = i2c.read(LSM303_ADDRESS,Data,2); // Read register contents
        Z = Data[1];
        Z = (Z << 8) + Data[0];
        
        updateAccelX(X);
        updateAccelY(Y);
        updateAccelZ(Z);        
        
    }
private:
    BLEDevice &ble;
    ReadOnlyGattCharacteristic<int16_t>  AccelX;
    ReadOnlyGattCharacteristic<int16_t>  AccelY;
    ReadOnlyGattCharacteristic<int16_t>  AccelZ;
};

#endif /* #ifndef __BLE_ACCEL_SERVICE_H__ */
