#ifndef DRV8825_H
#define DRV8825_H

#include "mbed.h"
#include "FastPWM.h"

#define PI 3.14
#define E6 1000000
#define E3 1000
#define M_TO_S 60

#define FORWARD 1
#define BACKWARD 0

#define START 0
#define STOP 1



/**
 * @brief Class qui permet de contrôler le modul
 * @author Aissaoui Yannis
 */
class DRV8825{
    public:
    DRV8825();
    DRV8825(PinName pinEN, PinName pinDIR, PinName pinStep);
    DRV8825(PinName pinEN, PinName pinDIR, PinName pinStep, float r, unsigned int pas);

    void setDir(uint8_t dir);
    void setEnable(uint8_t en);
    void moveRotSpeed(float viteseR);
    void moveLinSpeed(float vitesseL);


    private:
    /**
     * @brief m_pas : correspond au nombres de pas du moteur
     */
    unsigned int m_pas;
    /**
     * @brief m_rayon : rayon de la roue (en mm)
     */
    float m_rayon;
    /**
     * @brief m_en : pin pour contrôler le blocage des roues
     */
    DigitalOut* m_en;
    /**
     * @brief m_dir : pin pour contrôler le sens de rotation
     */
    DigitalOut* m_dir;
    /**
     * @brief m_step : pin pour contrôler la vitesse du moteur
     */
    FastPWM* m_step;

};


#endif //DRV8825_H
