#include "DRV8825.h"

/**
 * @brief Initialisation du modul avec des paramètres par défaut
 */
DRV8825::DRV8825(){


    m_en = new DigitalOut(PC_5);
    m_dir = new DigitalOut(PC_6);
    m_step = new FastPWM(PC_8);
    m_step->write(0.50);
    m_rayon = 10;
    m_pas = 200;
    m_en->write(STOP);
}


/**
 * @brief Initialisation du modul avec des paramètres choisis
 * @param en : pin En
 * @param dir : pin Dir
 * @param step : pin Step
 */
DRV8825::DRV8825(PinName en, PinName dir ,PinName step){
    m_en = new DigitalOut(en);
    m_dir = new DigitalOut(dir);
    m_step = new FastPWM(step);
    m_rayon = 100;
    m_pas = 200;
    m_step->write(0.50);
    m_en->write(STOP);
}
/**
 * @brief Initialisation du modul avec des paramètres choisis
 * @param en : pin En
 * @param dir : pin Dir
 * @param step : pin Step
 * @param r : rayon de la roue (en mm)
 * @param pas : nombre de pas
 */
DRV8825::DRV8825(PinName en, PinName dir, PinName step, float r, unsigned int pas){
    m_en = new DigitalOut(en);
    m_dir = new DigitalOut(dir);
    m_step = new FastPWM(step);
    m_rayon = r;
    m_pas = pas;
    m_step->write(0.50);
    m_en->write(STOP);
}


/**
 * @brief Permet d'affecter une directions à notre module
 * @param dir : l'état que l'on souhaite appliquer
 */
void DRV8825::setDir(uint8_t dir){
        m_dir->write(dir);
}

/**
 * @brief Permet de définir si l'on souhaite bloquer ou non le moteur
 * @param en : l'état que l'on douhaite appliquer
 */
void DRV8825::setEnable(uint8_t en){
        m_en->write(en);
}

/**
 * @brief Permet de définir la vitesse de rotation du moteur pas à pas (RPM)
 * @param vitesse : la vitesse que l'on souhaite atteindre
 */
void DRV8825::moveRotSpeed(float vitesse){
        vitesse= vitesse /M_TO_S;
        float t = 1/(m_pas*vitesse);
        m_step->period_us(t*E6);
        m_step->write(0.50);
}


/**
 * @brief Permet de définir la vitesse linéaire du moteur pas à pas (m/s)
 * @param vitesse : la vitesse que l'on souhaite atteindre
 */
void DRV8825::moveLinSpeed(float vitesse){
        
        vitesse= vitesse*E3;
        float t = (2*PI*m_rayon)/(m_pas*vitesse);
        m_step->period_us(t*E6);
        m_step->write(0.50);
}
