/* #include */
#include "pins.h"

/* Initialisation des drivers */
void drv_init()
{
    mot_dis();
    motGauche_fwd();
    motDroite_fwd();

    mode_M0 = 1;
    //mode_M1 = 1;
    //mode_M2 = 1;
}

/* Activation des moteurs */
void mot_en() // Activation des moteurs
{
    drvGauche.setEnable(START);
    drvDroite.setEnable(START);
}

/* Désactivation des moteurs */
void mot_dis() // Désactivation des moteurs
{
    drvGauche.setEnable(STOP);
    drvDroite.setEnable(STOP);
}

/* Rotation moteur vers l'avant */
void motGauche_fwd()
{
    drvGauche.setDir(FORWARD);
    //drvGauche.setDir(BACKWARD);
}

void motDroite_fwd()
{
    drvDroite.setDir(BACKWARD);
    //drvDroite.setDir(FORWARD);
}

/* Rotation moteur vers l'arrière */
void motGauche_bck()
{
    drvGauche.setDir(BACKWARD);
    //drvGauche.setDir(FORWARD);
}

void motDroite_bck()
{
    drvDroite.setDir(FORWARD);
    //drvDroite.setDir(BACKWARD);
}

/* Changement de vitesse des moteurs */
void vitesseMotG(double vitesse)
{
    drvGauche.moveLinSpeed((double)vitesse);
}

void vitesseMotD(double vitesse)
{
    drvDroite.moveLinSpeed((double)vitesse);
}

/* Fonction test des moteurs */
void test_drv()
{
    /* Rien */
}
