// Nom du fichier : motors.cpp
#include "pins.h"

void drv_init()
{
    mot_dis();
    motGauche_fwd();
    //motDroite_fwd();
    motDroite_bck();
    drvGauche.moveLinSpeed(0.01);
    drvDroite.moveLinSpeed(0.01);
    //mode = 0b111; // M0, M1 et M2 sont à 1

    mode_M0 = 1;
    //mode_M1 = 1;
    //mode_M2 = 1;
    
    //mot_en();
}

// ENABLE/DISABLE // Les deux modules ont le même enable

void mot_en()
{
    motG_en();
    motD_en();
}

void mot_dis()
{
    motG_dis();
    motD_dis();
}

void motG_en()
{
    drvGauche.setEnable(START);
}

void motD_en()
{
    drvDroite.setEnable(START);
}

void motG_dis()
{
    drvGauche.setEnable(STOP);
}

void motD_dis()
{
    drvDroite.setEnable(STOP);
}

// FORWARD
void motGauche_fwd()
{
    drvGauche.setDir(FORWARD);
    //drvGauche.setDir(BACKWARD);
}

void motDroite_fwd()
{
    drvDroite.setDir(BACKWARD);
    //drvDroite.setDir(FORWARD);
}

// BACKWARD
void motGauche_bck()
{
    drvGauche.setDir(BACKWARD);
    //drvGauche.setDir(FORWARD);
}

void motDroite_bck()
{
    drvDroite.setDir(FORWARD);
    //drvDroite.setDir(BACKWARD);
}


// FONCTIONS TESTS
//
void test_drv()
{
    /*
    mot_en();
    motGauche_fwd();
    motDroite_fwd();
    drvGauche.moveLinSpeed(0.250); // 0.035
    drvDroite.moveLinSpeed(0.250); // 0.035
    wait(2);
    motGauche_bck();
    motDroite_bck();
    wait(2);
    mot_dis();
    */

    /*
    mot_en();
    motGauche_fwd();
    motDroite_fwd();
    wait(2);
    mot_dis();
    */

    mot_en();
    mot_acc();
    wait(2);
    mot_dec();
    mot_dis();

    drvDroite.moveLinSpeed(0.050);
}

void mot_acc()
{
    double i = 0;

    while (i < vitesseSAT) {
        bt.printf("mot_acc() => i = %lf\r\n",i);
        drvDroite.moveLinSpeed(i);
        drvGauche.moveLinSpeed(i);
        i+=0.005;
        wait_ms(10);
    }
}

void mot_dec()
{
    double i = vitesseSAT;

    while (i > 0) {
        bt.printf("mot_dec() => i = %lf\r\n",i);
        drvDroite.moveLinSpeed(i);
        drvGauche.moveLinSpeed(i);
        i-=0.005;
        wait_ms(10);
    }
}

void testAngle(int cmdAngle) {}
