#include "captUS.h"
#include "pins.h"
#include "math.h"
//Nom du fichier : captUS.cpp

// Variables globales & timers
float us_out[6];
float* distance;
Timer tps;
Ticker ticker_US;


void captUS_init(){
    ::distance = new float(6); //équivalent au malloc()
    tps.reset();
    tps.start();
}


void captUS_trig(){
    tps.reset();
    trigger=1;
    wait_us(20);
    trigger=0;
}

void echoRise1(){us_out[0]=tps.read_us();}
void echoFall1(){us_out[0]=(tps.read_us()-us_out[0])/2;}

void echoRise2(){us_out[1]=tps.read_us();}
void echoFall2(){us_out[1]=(tps.read_us()-us_out[1])/2;}

void echoRise3(){us_out[2]=tps.read_us();}
void echoFall3(){us_out[2]=(tps.read_us()-us_out[2])/2;}

void echoRise4(){us_out[3]=tps.read_us();}
void echoFall4(){us_out[3]=(tps.read_us()-us_out[3])/2;}

void echoRise5(){us_out[4]=tps.read_us();}
void echoFall5(){us_out[4]=(tps.read_us()-us_out[4])/2;}

void echoRise6(){us_out[5]=tps.read_us();}
void echoFall6(){us_out[5]=(tps.read_us()-us_out[5])/2;}


float* convertToDistance(){
    /**************************************
     * Nous convertisons grâce au valeur  *
     * qui sont retournées par echoRiseX  *
     * et echoFallx                       *
     **************************************/
    
    for(char i = 0; i<6;i++){
        ::distance[i] = (us_out[i]*340)/1000;//conversion en distance(mm)
    }
    
    /****************************************
     * nous retournons l'adresse du tableau *
     ****************************************/
    return ::distance;
}

bool obstacleSpoted(float dist,double x_robot,double y_robot ,double phi, char I_theta){
    /**************************
     * convertion de ° en rad *
     **************************/
    double phiG = ((phi+(I_theta*THETA))*_PI_)/180;

    /***********************************
     * convertion de la norme grâce à  *
     * la norme et à l'angle           *
     ***********************************/
    double x_dect = dist * cos(phiG) + x_robot;
    double y_dect = dist * sin(phiG) + y_robot;
    
    
    changementBase(&x_dect,&y_dect);
    /*********************************************
     * vérification de la position de l'obstacle *
     *********************************************/
    if(x_dect > LARGEUR_TAB || x_dect < 0||y_dect >LONGUEUR_TAB||y_dect < 0){
        return false;
    }
    else{
        return true;
    }

}

void changementBase(double* x_detect, double* y_detect){
    /*****************************
     * l'origine de notres table *
     * se situe au coins         *
     * supérieur                 * 
     *****************************/
    *y_detect+=505;
    *x_detect+=5;
}


