/* #include */
#include "pins.h"

DigitalOut Led(LED1); // LED allumée pendant le stand-by
DigitalIn Tirette(PC_8);
InterruptIn BtnBlue(PC_13);
DigitalIn SwitchStrategie(PC_11);

/* Capteurs à ultrasons */
DigitalOut trigger(PB_9);
InterruptIn echo1(PA_11);
InterruptIn echo2(PB_12);
InterruptIn echo3(PB_2);
InterruptIn echo4(PB_1);
InterruptIn echo5(PB_15);
InterruptIn echo6(PB_14);

/* Drivers DRV8825 */
#define STEP1 PA_6
#define STEP2 PB_6
#define DIR1 PC_2
#define DIR2 PC_3
#define EN1 PA_15
#define EN2 PA_14
#define diametreRoue 51.45
#define rayonRoue (diametreRoue/2)
#define nbPas 6400
DigitalOut mode_M0(PB_7);
//DigitalOut mode_M1(PC_13); // Inutile
//DigitalOut mode_M2(PC_14); // Hardware
DRV8825 drvGauche(EN1,DIR1,STEP1,rayonRoue,nbPas);
DRV8825 drvDroite(EN2,DIR2,STEP2,rayonRoue,nbPas);

/* Codeurs (Réf : LPJ3806-1000BM-G5-24E) */
InterruptIn cdgA(PA_8); // Codeur de gauche
DigitalIn cdgB(PA_9);
InterruptIn cddA(PA_0); // Codeur de droite
DigitalIn cddB(PA_1);
