/* Équipe : Ares ENSEA
 *  Coupe de France de robotique 2020
 */


/* #include */
#include "pins.h"


/* Variables globales */
Ticker TickerGlobal; // Comptage du temps écoulé
int cptGlobal = 0;
bool match = 0; // Match == 1 => Le match est en cours
//bool toggledSwitch = 0;


/* Prototypes */
void btnBlueIT();
void globalCounterIT();


int main()
{
    pc.printf("\r\nAresCDF2020\r\n");
    bt.printf("\r\nAresCDF2020\r\n");

    /* Initialisation des drivers */
    drv_init();

    /* Initialisation des codeurs */
    cdgA.rise(&cdgaRise);
    cddA.rise(&cddaRise);
    cdgA.mode(PullUp);
    cddA.mode(PullUp);

    /* Initialisation des broches */
    Tirette.mode(PullDown);

    /* Initialisation des pavillons */
    FlagGOTO(90);

    /* Timers & tickers */
    TickerGlobal.attach(&globalCounterIT, 1.0);
    TimUS.start();

    TickUS_actu.attach(&captUS_trig,0.2);
    Ticker_asserv.attach(&asserv,0.015);
    //Ticker_affUS.attach(&affUltrasons,1.0);

    /* Initialisation des capteurs à ultrasons */
    echo1.rise(&echoRise1); // Interruptions pour les capteurs à ultrasons
    echo1.fall(&echoFall1);
    echo2.rise(&echoRise2);
    echo2.fall(&echoFall2);
    echo3.rise(&echoRise3);
    echo3.fall(&echoFall3);
    echo4.rise(&echoRise4);
    echo4.fall(&echoFall4);
    echo5.rise(&echoRise5);
    echo5.fall(&echoFall5);
    echo6.rise(&echoRise6);
    echo6.fall(&echoFall6);

    /* debug */
    pc.attach(&serialIT); // Interruption liaison série
    bt.attach(&bluetoothIT); // Interruption bluetooth
    pc.baud(9600);
    pc.format(8,SerialBase::None,1);
    bt.baud(9600);
    bt.format(8,SerialBase::None,1);

    /* Autres */
    //btnBlue.rise(&boutonBleu);

    if (SwitchStrategie == 1) {
        stratX_select = objX_bleu;
        x = x_init_bleu;
        y = y_init;
        O = O_init_bleu;
        Led = 1;
    } else {
        stratX_select = objX_jaune;
        x = x_init_jaune;
        y = y_init;
        O = O_init_jaune;
        Led = 0;
    }

    /* Boucle infinie */
    while(1) {
        if (Tirette == 1 && match == 0) { // Stand-by
            // Le match n'a pas encore commencé
            // Le compteur du match reste à 0
            //Led = 1;
            match = 0;
            cptGlobal=0;

            if (SwitchStrategie == 1) {
                stratX_select = objX_bleu;
                x = x_init_bleu;
                y = y_init;
                O = O_init_bleu;
                Led = 1;
            } else {
                stratX_select = objX_jaune;
                x = x_init_jaune;
                y = y_init;
                O = O_init_jaune;
                Led = 0;
            }
        }

        else if (Tirette == 0 && match == 0) { // Début du match
            // Le match débute
            // La LED s'éteind
            //Led = 0;
            match = 1;
            cptGlobal = 0;

            indiceStrategie = 1;
            action = objEtape[indiceStrategie];
            xC = stratX_select[indiceStrategie];
            yC = objY[indiceStrategie];
        }

        if (indiceStrategie >= NbObj) {
            action = 0;
        }
    }
}

void btnBlueIT()
{
    /* Rien */
}

void globalCounterIT()
{
    cptGlobal++;

    if(cptGlobal==95) { // Le drapeau doit être hissé à 95sec
        FlagGOTO(0);
    }

    if(cptGlobal>=100) { // Le robot doit s'arrêter à 100sec
        action=0;
    }
}
