#include "pins.h"

PwmOut servo(FLAGPIN);
Timeout response;


void FlagGOTO(int pos)
{
    servo = (pos*(0.05f)/90)+0.075f;
}

void FlagFROMGOTO(int posinit, int posfin, int pas)
{
    int dir = ((posfin - posinit)/abs(posfin - posinit));
    for(int pos = posinit; pos != posfin; pos = pos + (pas*dir)) {
        FlagGOTO(pos);
        wait_ms(FLAGDELAY2POS);
    }
}

void FlagCCW(void)
{
    FlagGOTO(90);
    //servo = 0.125f;
}

void FlagMid(void)
{
    FlagGOTO(0);
    //servo = 0.075f;
}

void FlagCW(void)
{
    FlagGOTO(-90);
    //servo = 0.024f;
}

void FlagUpToInit()
{
    FlagFROMGOTO(0, 90, 1);
}

void FlagInitToUp()
{
    FlagFROMGOTO(90, 0, 1);
}

void Detonateur(float time)
{
    response.attach(&FlagInitToUp, time);
}