
#include "quick_queue.h"
#include "mbed.h"

radio_message_t out_messages[MESSAGE_BUFFER_SIZE];// = { 0, 0, 0, 0, "0", 0, 0};
int out_output_index = 0;
int out_input_index = 0;

radio_message_t in_messages[MESSAGE_BUFFER_SIZE];// =  { 0, 0, 0, 0, "0", 0, 0};
int in_output_index = 0;
int in_input_index = 0;

// Utilise pour aller chercher une pointeur vers un message a remplir pour l'envoi
radio_message_t* get_new_out_message(){
    if (((out_input_index + 1) % MESSAGE_BUFFER_SIZE) != out_output_index) 
    {
        return &(out_messages[(out_input_index + 1) % MESSAGE_BUFFER_SIZE]);
        //return true;
    }
    return NULL;
}

// Inique que le message courant est pret a etre envouye
bool new_out_message_ready(){
    if (((out_input_index + 1) % MESSAGE_BUFFER_SIZE) != out_output_index) 
    {
        out_input_index = (out_input_index + 1) %  MESSAGE_BUFFER_SIZE;
        return true;
    }
    return false;
}

// Utilise pour aller chercher le plus vieux message en sortie
radio_message_t* get_last_out_message(){
    if (out_output_index != out_input_index) 
    {
        return &(out_messages[(out_output_index + 1) % MESSAGE_BUFFER_SIZE]);
        //return true;
    }
    return NULL;
}

// Indique que le message a ete envoye
bool last_out_message_read(){
    if (out_output_index != out_input_index) 
    {
        out_output_index = (out_output_index + 1) % MESSAGE_BUFFER_SIZE;
        for (int i = 0; i < MAX_MESSAGE_LENGTH; i++)
        {
            out_messages[out_output_index].data[i] = 0;
        }
        return true;
    }
    return false;
}

// Utilise pour aller recuperer un nouveau message a remplir pour la reception
radio_message_t* get_new_in_message(){
    if (((in_input_index + 1) % MESSAGE_BUFFER_SIZE) != in_output_index) 
    {
        return &(in_messages[(in_input_index + 1) % MESSAGE_BUFFER_SIZE]);
        //return true;
    }
    return NULL;
}

// Indique qu'un nouveau message est pret en entree
bool new_in_message_ready(){
    if (((in_input_index + 1) % MESSAGE_BUFFER_SIZE) != in_output_index) 
    {
        in_input_index = (in_input_index + 1) %  MESSAGE_BUFFER_SIZE;
        return true;
    }
    return false;
}

// Utilise pour aller chercher le dernier message pret
radio_message_t* get_last_in_message(){
    if (in_output_index != in_input_index) 
    {
        return &(in_messages[(in_output_index + 1) % MESSAGE_BUFFER_SIZE]);
        //return true;
    }
    return NULL;
}

// Indique que le dernier message a bien ete lu
bool last_in_message_read(){
    if (in_output_index != in_input_index) 
    {
        in_output_index = (in_output_index + 1) % MESSAGE_BUFFER_SIZE;
        for (int i = 0; i < MAX_MESSAGE_LENGTH; i++)
        {
            in_messages[in_output_index].data[i] = 0;
        }
        return true;
    }
    return false;
}


int get_input_out_index()
{
    return in_output_index;
}

int get_input_in_index()
{
    return in_input_index;
}