#pragma once

#include "radio.h"
// Taille des buffers de reception/envoi (maximums de messages)
#define MESSAGE_BUFFER_SIZE 16

// Utilise pour aller chercher une pointeur vers un message a remplir pour l'envoi
radio_message_t* get_new_out_message();
// Inique que le message courant est pret a etre envouye
bool new_out_message_ready();

// Utilise pour aller chercher le plus vieux message en sortie
radio_message_t* get_last_out_message();
// Indique que le message a ete envoye
bool last_out_message_read();

// Utilise pour aller recuperer un nouveau message a remplir pour la reception
radio_message_t* get_new_in_message();
// Indique qu'un nouveau message est pret en entree
bool new_in_message_ready();

// Utilise pour aller chercher le dernier message pret
radio_message_t* get_last_in_message();
// Indique que le dernier message a bien ete lu
bool last_in_message_read();

int get_input_out_index();
int get_input_in_index();