
#include "crc.h"

#define POSSIBLE_VALUES 256

char crc_table[POSSIBLE_VALUES];

void init_crc_module()
{
    /* iteration sur toutes la valeurs possible de CRC pour le valeurs de byte possible */
    for (int i = 0; i < POSSIBLE_VALUES; i++)
    {
        char current_byte = (char)i;
        /* calcul de la valeur de CRC pour le byte actuel a l'aide des operations bit a bit avec XOR */
        for (char bit = 0; bit < 8; bit++)
        {
            /* lorsque la valeur du MSB est 1, on execute le XOR en plus du decalage */
            if ((current_byte & 0x80) != 0)
            {
                current_byte = current_byte << 1;
                current_byte ^= CRC_GEN_NUM;
            }
            else
            {
                current_byte = current_byte << 1;
            }
        }
        /* en ajoute cette valeur a la table des valeurs pre calculees */
        crc_table[i] = current_byte;
    }
}

char get_crc_value(char* buffer, int buffer_length)
{
    char crc = 0;
    for (int i = 0; i < buffer_length; i++)
    {
        /* get current CRC value = remainder */
        crc = crc_table[buffer[i] ^ crc];
    }

    return crc;
}