
#pragma once

#define HEADER_DELIMITER 0b01010101

#define HEADER_START 0b01111110

#define FOOTER_END 0b11111110

#define MAX_MESSAGE_LENGTH 80

typedef char byte;

typedef struct {
    byte preambule;
    byte start;
    byte options;
    byte length;
    byte data[MAX_MESSAGE_LENGTH];
    byte control;
    byte end;
} radio_message_t;

// API
// public functions
void init_radio_system();

bool send_message(char* buffer, int length);

bool get_message(radio_message_t* message);