#include "mbed.h"

#include "radio.h"

// Debug serial output
Serial debug_output(USBTX, USBRX);

void display_all_messages();

int main() {
    init_radio_system();
    send_message("System startup", 14);
    while(1) {
        debug_output.printf(":::Main loop:::\n\r");
        send_message("Mars rover 1 : data start", 25);
        wait_ms(250);
        send_message("x:22 y:42 z:12", 14);
        wait_ms(250);
        send_message("All systems green", 17);
        wait_ms(250);
        send_message("I AM GROOT", 10);
        wait_ms(250);
        send_message("Mars rover 1 : data end", 23);
        wait_ms(250);
        display_all_messages();
    }
}

void display_all_messages(){
    radio_message_t* message;

    while(get_message(message))
    {
        // Display messages
        debug_output.printf("===========================\n\r");
        debug_output.printf("===========START===========\n\r");
        debug_output.printf("Start value = 0x%x\n\r", message->start);
        debug_output.printf("Options value = 0x%x\n\r", message->options);
        debug_output.printf("Length value = %u\n\r", message->length);

        debug_output.printf("Message value = %s\n\r", message->data);

        debug_output.printf("CRC value = 0x%x\n\r", message->control);
        debug_output.printf("End value = 0x%x\n\r", message->end);
        debug_output.printf("===========================\n\r");
        //format
        message = NULL;
    }
}