#include "sensors.h"

MMA8452Q accel(p9, p10, 0x1D); // (I2c) SDA - SCL
DigitalIn Bouton1(p20);

sensor_t readAccel(); 
sensor_t readBouton1();

sensor_t (*p[2])();

 // Initialisation des capteurs
void initialize_sensors()
{
    accel.init();     
    p[0] = readAccel;
    p[1] = readBouton1;
    
    //Ajouter votre initialisation de capteur ici
}

// Fonction de lecture de l'accéléromètre
sensor_t readAccel()
{
    sensor_t Result;
    Result.sensor_type = type_accelerometre;
    Result.sensor_result.Accelerometre.x = accel.readX();
    Result.sensor_result.Accelerometre.y = accel.readY();
    Result.sensor_result.Accelerometre.z = accel.readZ();
    return Result;
}

// Fonction de lecture du Bouton
sensor_t readBouton1()
{
    sensor_t Result;
    Result.sensor_type = type_bouton;
    Result.sensor_result.Bouton.etat = Bouton1;   
    return Result;
}
