/**
*   APP3 : Jean-Phillippe Fournier fouj1807 & Jean-Pascal McGee mcgj2701
*   parser.h - Lecture du fichier de configuration du coordinatuer
*/

#include "parser.h"

LocalFileSystem local("local");

// Lecture du fichier de config du coordinateur
coordinator_config_t read_coordinator_config()
{
    coordinator_config_t config;

    Serial pc(USBTX, USBRX); // tx, rx
    FILE *fp = fopen("/local/config.txt", "r");  // Ouvrir config.txt pour lecture seulement
    pc.printf("Opening configuration file for the coordinator\n\r");
    if (fp == NULL) // Echec de l'ouverture de fichier
    {
        pc.printf("Failed to find configuration file. Setting default configuration\n\r");
        
        sprintf(config.server_url, "localhost");
        config.pan_id = 0x1;
    }
    else // Succes de l'ouverture du fichier
    {
        pc.printf("Config file opened. \n\r");
        fscanf(fp,"0x%x", &config.pan_id);  // Lire le PanId      
        fscanf(fp,"%s", config.server_url); // Lire l'adresse URL        
        fclose(fp); // Fermer le fichier
        
        // Afficher le contenue pour confirmation
        pc.printf("PanId : 0x%x value : %u\r\n", config.pan_id, config.pan_id); // Display PanId
        pc.printf("ServeurURL : %s\r\n",config.server_url); // Display URL
    }
    return config;
}

router_config_t read_router_config()
{
    router_config_t config;
    
    Serial pc(USBTX, USBRX); // tx, rx
    FILE *fp = fopen("/local/config.txt", "r");  // Ouvrir config.txt pour lecture seulement
    pc.printf("Opening configuration file for the router\n\r");
    if (fp == NULL)  // Echec de l'ouverture de fichier
    {
        pc.printf("Failed to find configuration file. Setting default configuration\n\r");
        
        config.refresh_freq = 0x1;
        config.pan_id = 0x1;
    }
    else // Succes de l'ouverture du fichier
    {
        pc.printf("Config file opened. \n\r");
        fscanf(fp,"0x%x", &config.pan_id);     // Lire le PanId
        fscanf(fp,"%u", &config.refresh_freq); // Lire la fréquence de rafraichissement
        fclose(fp); // Fermer le fichier
                      
        // Afficher le contenue pour confirmation
        pc.printf("PanId : 0x%x value : %u\r\n", config.pan_id, config.pan_id); // Display PanId
        pc.printf("Sensor refresh rate : %u\r\n",config.refresh_freq); // Display URL
    }
    return config;
}
