#include "mbed.h"
#include "TextLCD.h"


DigitalOut myled(PC_13);
TextLCD lcd(PA_4, PA_5, PA_6, PB_12, PB_13, PB_14, PB_15);
AnalogIn adc(PA_0);
Serial serial(PA_9, PA_10);
InterruptIn botao(PA_7);
volatile bool botao_pressed = false; // Used in the main loop
volatile bool botao_enabled = true; // Used for debouncing
Timeout botao_timeout; // Used for debouncing

PwmOut saida(PA_1);


float conversao, tensao = 0, res, cor;
char leitura;
int conta;

/* CONFIGURAÇÃO BOTÃO*/

void botao_enabled_cb(void)
{
    botao_enabled = true;
}

void botao_onpressed_cb(void)
{
    if (botao_enabled) { // Disabled while the button is bouncing
        botao_enabled = false;
        botao_pressed = true; // To be read by the main loop
        botao_timeout.attach(callback(botao_enabled_cb), 0.3); // Debounce time 300 ms
    }
}


int main() {
    
    
    serial.baud(115200);
    saida.period_ms(1);
  //  led.period(4.0f);      // 4 second period
    saida.write(0.80f);
    botao.mode(PullUp);
    botao.fall(callback(botao_onpressed_cb));

        conta =0;
        myled=0;
    while(1) {
       
        tensao = adc.read();
        
        
         if (botao_pressed) { // Set when button is pressed
           
        botao_pressed = false;
        conta++;
        myled=!myled;
        
        
        }
        
        if(conta > 3)conta=1;
        
      //  lcd.gotoxy(1,1);
        //lcd.printf("%d", conta);
        
    
     if(conta == 1)
     {
        wait(0.2);                
        lcd.gotoxy(1,1);
        //tensao = adc.read();
        tensao = tensao*3.3;
        lcd.printf("Tensao: %.2f    ", tensao);
        serial.printf("Tensao: %.2f\n\n\n\n\n\n\n\n\n", tensao);
        }
       
        
        
        /*
      if(leitura == 'R')
      
      {
        res = adc.read();
        conversao = (res*3.3);
        res = (conversao*9950)/(3.3-conversao);
        wait(0.2);
        lcd.gotoxy(1,1);
        lcd.printf("R: %.2f KOhms", res/1000);
        serial.printf("R: %.2f KOhms\n\n\n\n\n\n\n\n\n", res/1000);
        
        }  
        
      if(leitura == 'C')
        {
            cor = adc.read();
            conversao = (cor*3.3);
            res = (conversao * 9950) / (3.3 - conversao);
            cor = (conversao/res);
            wait(0.2);
            lcd.gotoxy(1,1);
            lcd.printf("C: %.2f uA", cor*1000000);
            serial.printf("C: %.2f uA\n\n\n\n\n\n\n\n\n", cor*1000000);
            
            }
        */
    }
}
 