/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Proyecto_bluetooth
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 28-05-2019, 11:48, # CodeGen: 0
**    Descripción    :
**     Poryecto de domotica para control de sensores, por app en celular, registro de temperatura y  humedad.    
**         
**   Componentes     : GPIO, Inteerupt, NFC,  .
**   Configuraciones : IRF, DTH11
**   Autores         : JOSÉ CARLOS ARRATIA CASAS
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 28/05/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    
**
* ###########################################################################/
*/
#include "mbed.h"
#include "Serial.h"
#include "string.h"
#include "stdio.h"
#include"stdlib.h"
#include "Dht11.h"
#include "MFRC522.h"
#include "Servo.h"


#define MF_RESET    D8 
DigitalIn sensor_g (PTB20);
DigitalOut rojo(LED_RED);
DigitalOut led_pir(PTE16);
DigitalOut led_1 (PTE6);
DigitalOut led_2(PTE3);
DigitalOut led_3 (PTE2);
Serial bluetooth(PTE20, PTE21);
Dht11 sensor_t(PTD4);
DigitalIn pir(PTA13);
DigitalOut buzzer (PTD3);
DigitalOut led_rojo (PTB19);
DigitalOut led_verde (PTC0);
MFRC522    RfChip   (PTD6, PTD7, PTD5, PTC9, PTD2);
DigitalOut servo(PTA4);

void open(){
    for(int hz=0; hz<50; hz++){
            servo=1;
            wait_us(2300);
            servo=0;
            wait_ms(18);
            }
    
     
led_rojo= !led_rojo;
led_verde= !led_verde;
}
void close (){
    for(int hz=0; hz<50; hz++){
            servo=1;
            wait_us(700);
            servo=0;
            wait_ms(20);
            }
    led_rojo= !led_rojo;
led_verde = !led_verde;
    
    }

/* sensor.read()
     pc.printf("T: %f, H: %d\r\n", sensor.getFahrenheit(), sensor.getHumidity());*/
/////////////////////////PROGRAMA PRINCIPAL///////////////////////////////////


int main()
{
  buzzer=1;
  //myservo.calibrate(2.0, 0.0);
  led_rojo=1;
  led_verde=0;
  RfChip.PCD_Init();
  
  led_1=1;// por el rele
  led_2=1; //por rele
  led_3=0; //led de potencia;
  led_pir=0;
  bluetooth.baud(115200);
    char selec='0';

 
  wait_ms(500);
   while(true){
       if (  RfChip.PICC_IsNewCardPresent())
    {
     buzzer=0;
     wait_ms(10);
     buzzer=1;
     open();
      wait(2);
      close();
      // continue;
    }
       sensor_t.read();
led_pir=pir.read();
 
  bluetooth.printf("%d,%d,",sensor_t.getCelsius(), sensor_t.getHumidity());
    rojo=1;
                    
            wait(2);
            rojo=0;
          
   
   if(bluetooth.readable()){
       selec = bluetooth.getc();
       switch(selec){
           case 'a':{
               led_1=0; // en caso de usar rele por que se activa con un cero
              
               }
               break;
           case 'b':{led_1 =1;} // en caso de usar rele
               
           break;
           case 'c':{led_2=0;} //hecho para usar rele
           break;
           case 'd':{led_2=1;}//hecho para usar rele
           break;
           case 'e':{led_3=1;}// led de potencia
           break;
           case 'f': {led_3=0;}
           break;
           }
              
       selec='0';
       }   
      if(sensor_g==0){
           int lec_g=0;
           while(lec_g==0){
               led_1=led_2=led_pir=buzzer=0;
               led_3=1;
               wait_ms(1000);
               led_1=led_2=led_pir=buzzer=1;
               led_3=0;
               wait_ms(1000);
               lec_g=sensor_g.read();
               
               
           }
           }
       
       
       
       
       
           
     }
       
     
}