/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Plantilla
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace el monitoreo de un recipiente con agua, mediante sensores infrarrojos emisor y receptor, para encender motores que 
**         facilitan el llenado de este.
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         : Méndez Vilchis Emilio
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 18/05/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
* ###########################################################################/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"


DigitalIn sens1(PTE31); //inicializa canal digital para sensor 1
DigitalIn sens2(PTE19); //inicializa canal digital para sensor 2
DigitalIn sens3(PTE18); //inicializa canal digital para sensor 3

DigitalOut gseg(PTE20);   // Inicializa el segmento g del display de catodo comun
DigitalOut fseg(PTE21);     // Inicializa el segmento f del display de catodo comun
DigitalOut aseg(PTE22);  // Inicializa el segmento a del display de catodo comun
DigitalOut bseg(PTE23);     // Inicializa el segmento b del display de catodo comun
DigitalOut eseg(PTE17);  // Inicializa el segmento e del display de catodo comun
DigitalOut dseg(PTE16);  // Inicializa el segmento d del display de catodo comun
DigitalOut cseg(PTE6);  // Inicializa el segmento c del display de catodo comun

DigitalOut motor1(PTB18); // Inicializa motor 1
DigitalOut motor2(PTB19); // Inicializa motor 2

DigitalOut Buzzer(PTE30); // Inicializa el buzzer (indica al usuario cuando el agua llega al tope del recipiente)

//t cero=0;
//t uno=1;

int main()
{
    while(1) {     //ciclo infinito, para la connstate lectura de los datos de entrada
        if(sens1.read()==0) {   // Recordando que el sensor receptor emisor al no tener una interrupcion entrela señal delel emisor y receptor nos regresara un 1 
                                // Al interferir la señal de este se marcara un 0 y por lo tanto, al tener el primer sensor tapado podemos inferir que el nivel de agua en el
                                //sensor esta en el nivel mas bajo.
            gseg=1;
            fseg=0;
            aseg=1;    ////// el display marca un 2 al mandar 1 a los segmentos de este
            bseg=1;
            eseg=1;
            dseg=1;
            cseg=0;


            motor1=1;        // Se procede a encender ambos motores para hacer mas rapido el llenado del agua
            motor2=1;

        }

        else if (sens1.read()==0 && sens2.read()==0){ /// al tener interrupcion de la señal en los primeros 2 sensores (nivel inferior y nivel medio)
        gseg=0;
        fseg=0;
        aseg=0;
        bseg=1; // imprime 1 en el display, indicando que solo un motor trabajara
        eseg=0;
        dseg=0;
        cseg=1;
        motor1=1;  // el motor 1 sigue su proceso de llenado
        motor2=0;  // el motor 2 se apaga, pues no es necesario que el recipiente siga llenandose con la misma rapidez
    }

    else if (sens1.read()==0 && sens2.read()==0 && sens3.read()==0){ // si los 3 sensores tienen su señal interrumpida, sabremos que estamos en el nivel 3
             
             gseg=1;
             fseg=1;
             aseg=1;
             bseg=0;          //// estamos en el nivel 3 y se le manda 1 a los segmentos que se requieren para marcar este nivel en el diaplay
             eseg=1;
             dseg=1;
             cseg=0;
             
             
             Buzzer=1;      /// Se acciona el buzzer, como aviso al usuario, el recipiente esta lleno}
             
             motor1=0;       /// no es necesario continuar el llenado del recipiente, se procede a mandar 0 a los motores, apagandolos.
             motor2=0;
    }
}

}
