/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Proyecto_Implementacion_Bluetooth
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 22-05-2019, 23:57, # CodeGen: 0
**    Descripción    :
**         Este proyecto, mediante la implementacion del modulo Bluetooth
**         HC-05 tiene la finalidad de, desde una aplicacion serial Bluetooth 
**         en cualquier smartphone, poder controlar las secuencias en que 
**         se desplaza una tira de leds implementada con leds individuales, 
**         ademas de la funcion on/off, a futuro se piensa desarrollar este  
**         proyecto con la imlementacion de leds inteligentes y sensores de 
**         proximidad cuyo proposito sea representar a grandes razgos la tecnología 
**         self-drive o self-lightning de los automoviles de mayor gama alta en 
**         la actualidad.
**   Componentes     : GPIO, Bluetooth HC-05, Serial, BusOut, Smartphone.
**   Configuraciones : Includes, Serial y Drivers externos
**   Autores         : Mendoza Narcia Erick Daniel
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   : 
**   Date           : 01/08/2019 (aproximacion)
**                    Implementacion de leds inteligentes y sensores de proximidad
**
* ###########################################################################/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "Serial.h" 
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
DigitalOut gpo(D0);
DigitalOut led(LED_RED);
Serial Bluetooth(PTE0, PTE1); //establecemos los pines para la comunicacion serial
                            //de la tarjeta con el bluetooth, PTE0 como RX y PTE1 como TX
BusOut SECUENCIAS(PTE23, PTE22, PTE21, PTE20, PTE19, PTE18, PTE17, PTE16);//de estos
                            //pines se conectaran los leds cuyas direcciones de iluminacion
                            //podran ser controlados por la aplicacion de smartphone 
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
char DATO; //variable para almacenar caracter recibido desde el smartphone
int16_t i=0; //variable auxiliar contador
int32_t NSec=33; //variable auxiliar para el numero de secuencias de los vectores
int32_t NSec2=160; //variable auxiliar para el numero de secuencias de los vectores
/*

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
uint8_t SHOW6[]={0xFF};
uint8_t SHOW5[]={0x55,0x55,0x55,0x55,0xAA,0xAA,0xAA,0xAA,0x55,0x55,0x55,0x55,0xAA,0xAA,0xAA,0xAA,
                 0x55,0x55,0x55,0x55,0xAA,0xAA,0xAA,0xAA,0x55,0x55,0x55,0x55,0xAA,0xAA,0xAA,0xAA};
uint8_t SHOW4[]={0x81,0x81,0x42,0x42,0x24,0x24,0x18,0x18,0x81,0x81,0x42,0x42,0x24,0x24,0x18,0x18,
                 0x81,0x81,0x42,0x42,0x24,0x24,0x18,0x18,0x81,0x81,0x42,0x42,0x24,0x24,0x18,0x18};
uint8_t SHOW3[]={0x18,0x18,0x24,0x24,0x42,0x42,0x81,0x81,0x18,0x18,0x24,0x24,0x42,0x42,0x81,0x81,
                 0x18,0x18,0x24,0x24,0x42,0x42,0x81,0x81,0x18,0x18,0x24,0x24,0x42,0x42,0x81,0x81};
uint8_t SHOW2[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80,0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80,
                 0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80,0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
uint8_t SHOW1[]={0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01,0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01,
                 0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01,0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};
uint8_t SHOW0[]={0x00};

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/

int main (){
    Bluetooth.baud(9600); //velocidad de baudios a la cual la tarjeta se conectara al modulo 
                            //Bluetooth HC-05
    while(1){ //loop
        if(Bluetooth.readable()) // Si el modulo bluetooth esta disponible y hay informacion
                                //disponible para que este reciba
        {
            DATO=Bluetooth.getc(); //almacenara en esta variable el caracter que se recibio 
                                    //desde el modulo 
            i=0;
            if(DATO=='1')   //Si el dato recibido es 1, ejecuta un vector que representa una 
                            //forma de mostrar la iluminacion de la tira de leds, lo mismo 
                            //en los demas casos con diferentes formas y secuencias de encendido
                            //a menos que se indique la accion 
            {
                for(i=0;i<NSec;i++)
                {
                    SECUENCIAS=SHOW1[i];
                    wait_ms(70);
                }
            }
            if(DATO=='2')
            {
                for(i=0;i<NSec;i++)
                {
                    SECUENCIAS=SHOW2[i];
                    wait_ms(70);
                }
            }
            if(DATO=='3')
            {
                for(i=0;i<NSec;i++)
                {
                    SECUENCIAS=SHOW3[i];
                    wait_ms(70);
                }
            }
            if(DATO=='4')
            {
                for(i=0;i<NSec;i++)
                {
                    SECUENCIAS=SHOW4[i];
                    wait_ms(70);
                }
            }
            if(DATO=='5')
            {
                for(i=0;i<NSec;i++)
                {
                    SECUENCIAS=SHOW5[i];
                    wait_ms(70);
                }
            }
            if(DATO=='6')
            SECUENCIAS=SHOW6[i];//leds On
            if(DATO=='7')
            {
                for(i=0;i<NSec2;i++)
                {
                    SECUENCIAS=SHOW5[i];
                    wait_ms(70);
                }
            }
            if(DATO=='0')
            SECUENCIAS=SHOW0[i]; //leds Off
            }
        }
}
/* END main */

/*

/* END Program */

/* END Mbed */