/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Plantilla
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 24-05-2019, 00:48, # CodeGen: 0
**    Descripción    :
**         
**         This Proyect Measures the heart rate in one minute. and shows it on a 20X4 LCD screen.
**   Componentes     : GPIO, Timer, etc ,DisplayLCD,KeyPad,Dispay 7segmentos,"AD8232 with electrodes for heart".
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          -Josué Leonardo López García and
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 24/05/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
* ###########################################################################/

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "TextLCD.h" //Este archivo contiene la libreria para manipular el DiplayLCD
#include "Keypad.h" //Este archivo contiene la libreria para manipular el TecladoMatricial
//#include "MyNewTLCD.h" //Este archivo contiene la libreria para dibujar la señal de onda
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define TRUE 1
#define FALSE 0

/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
DigitalIn Digital(PTE1); //Confifuracion de una entrada digital 
DigitalIn Digital1(PTE0);//Confifuracion de una otra entrada digital 
DigitalOut LedG(LED1);
DigitalOut LedR(LED2);
BusOut SalidaSeg(PTB18,PTC10,PTC11,PTC7,PTB19,PTC4,PTC6,PTC0);//Confifuracion de la salida de segmentos del Diplay 7Seg 
BusOut SalidaDig(PTA12,PTD3,PTA2,PTA1);//Confifuracion de la salida de Digitos del Diplay 7Seg 
TextLCD lcd(PTE20,PTE21,PTE22,PTE23,PTB20,PTE30,TextLCD::LCD20x4); // rs, e, d4-d7 Confifuracion de la salida del DiplayLCD y sus datos
Keypad TecMat(PTE16,PTE6,PTE3,PTE2,PTE31,PTE19,PTE18,PTE17);//Confifuracion de puertos para el Teclado Matricial
DigitalOut gpo(D0);
DigitalOut led(LED_RED);
AnalogIn A(A0);//Confifuracion de la Entrada Analogica 
Timer relog;  //Timer que fungira como contador en segundos para monitoriar el tiempo
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/

uint16_t cont_1ms=0,scan_rate=0,counter=500,flag1,flag2,flag3,cont_10ms=0,cont_100ms=0,cont_1s=0;//Declaracion e inicializacion de los contadores y banderas
int16_t i=0;
uint16_t Digito[]={0x01,0x02,0x04,0x08};//Orden de los Digitos del Display de 7Seg
uint16_t Number[]={0x81,0xE7,0x49,0x43,0x27,0x13,0x11,0xC7,0x01,0x03,0xFF};
char key; //Variable de tipo caracter que sera designada por el teclado matricial
int released=1,tiemp=0,j=0;//inicializacion de variables de las funciones
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

//funcion1
uint16_t Letra(uint8_t L){    //Funcion encargada de recibir un numero para despues codificarlo y poder ser mostrado en el display de 7Seg
        if(L=='0')return 0x81;
        else if(L=='1')return 0xE7;
        else if(L=='2')return 0x49;
        else if(L=='3')return 0x43;
        else if(L=='4')return 0x27;
        else if(L=='5')return 0x13;
        else if(L=='6')return 0x11;
        else if(L=='7')return 0xC7;
        else if(L=='8')return 0x01;
        else if(L=='9')return 0x03;
        else if(L=='A'||L=='a')return 0x05;
        else if(L=='B'||L=='b')return 0x31;
        else if(L=='C'||L=='c')return 0x99;
        else if(L=='D'||L=='d')return 0x61;
        else if(L=='E'||L=='e')return 0x19;
        else if(L=='F'||L=='f')return 0x1D;
        else if(L=='G'||L=='g')return 0x03;
        else if(L=='H'||L=='h')return 0x25;
        else if(L=='I'||L=='i')return 0xFD;
        else if(L=='J'||L=='j')return 0xE1;
        else if(L=='K'||L=='k')return 0x29;
        else if(L=='L'||L=='l')return 0xB9;
        else if(L=='M'||L=='m')return 0x85;
        else if(L=='N'||L=='n')return 0x75;
        else if(L=='O'||L=='o')return 0x81;
        else if(L=='P'||L=='p')return 0x0D;
        else if(L=='Q'||L=='q')return 0x07;
        else if(L=='R'||L=='r')return 0x7D;
        else if(L=='S'||L=='s')return 0x13;
        else if(L=='T'||L=='t')return 0x39;
        else if(L=='U'||L=='u')return 0xF1;
        else if(L=='V'||L=='v')return 0xA1;
        else if(L=='W'||L=='w')return 0xD1;
        else if(L=='X'||L=='x')return 0x3D;
        else if(L=='Y'||L=='y')return 0x23;
        else if(L=='Z'||L=='z')return 0x5B;
        else if(L=='-')return 0x7F;
        else if(L=='=')return 0x7B;
        else if(L=='.')return 0xFE;
        else if(L==' ')return 0xFF;
        else return 0xFF;
}

//funcion2
void barrido(){//Funcion que se encarga del barrido del display de 7Seg 
    cont_1ms++;
    scan_rate++;
    counter--;
    if(scan_rate==2)
    {
        scan_rate=0;          
        flag1=TRUE;
    }
    if(scan_rate==1)
    {         
        flag3=TRUE;
    }        
    if (cont_1ms>=10)
    {
        cont_10ms++;
        cont_1ms=0;
    }      
    if (cont_10ms>=10)
    {
        cont_100ms++;
        cont_10ms=0;
    }    
    if (cont_100ms>=10)
    {
        cont_1s++;
        cont_100ms=0;
    }    
    if (cont_1s>=10) 
    {
        cont_1s=0;
    }
    if (!counter)
    {
        counter=500;
        flag2=TRUE;            
    }
    }

//funcion3

void teclado()
{//Funcion se encarga de asignar un caracter a la variable key dependiendo del estado del teclado matricial
      key=TecMat.ReadKey();
    if(key=='\0')
    released=1;
    if((key!='\0') && (released==1))
    {
        lcd.printf("%c",key);
        released=0;  

        }
} 

//funcion4

void WelcomToECG(void){
        //Esta funcion se encarga de dar la bienvenida al ECG y dar instrucciones al usuario para su correcto funcionamiento    
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Bienvenido al ECG.");
        lcd.locate(0,1);
        lcd.printf("Por favor coloca los");
        lcd.locate(0,2);
        lcd.printf("electrodos referente"); 
        lcd.locate(0,3);
        lcd.printf("al triangulo de");wait(5);
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Eithoven.");wait(3);
        lcd.cls();
        lcd.printf("Tiempo de espera: 3 seg.");wait(05);
        lcd.cls();
lcd.locate(0,0);
lcd.printf("Por favor, mantenga");
lcd.locate(0,1);
lcd.printf("presionada la tecla ");
lcd.locate(0,2);
lcd.printf("A Si ya tiene");
lcd.locate(0,3);
lcd.printf("los electrodos ");wait(6);
lcd.cls();
    }

    
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/

int main()
{
 
    Ticker timer;//Declaracion de un timer usado en el barrido del display
    timer.attach_us(&barrido,500);
    
      uint16_t longitud=63;//Se designa una longitud para el mensaje que queremos mostrar
    int16_t j=0,e=0;
    while(e<3){//Lazo principal del corrimiento del display el corrimiento solo se hara 2 veces
        uint8_t Cadena[]="HOLA ESIME ZACATENCO ING EN COMUNICACIONES Y ELECTRONICA ";
        uint8_t Apaga[]=" ";
        if (flag1==TRUE){
            SalidaSeg = Letra(Apaga[0]);
            SalidaDig = Digito[-i+3];
            SalidaSeg = Letra(Cadena[i+j-5]);
        
            i++;
            if(i==4)i=0;
            if(j==longitud)j=0;
            LedR=!LedR;
            flag1=FALSE;
            
        }    
       if (flag2==TRUE){
           LedG=!LedG;
           flag2=FALSE;
           j++;
       } 
       e++;
    }
    
    
    
   
  //Inicio del Programa, se muestra en el DisplayLCD
Inicio:
      key=NULL;
    lcd.printf("ELECTROCARDIOGRAMA");wait(4);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Hola!");
    lcd.locate(0,1);
    lcd.printf("Este dispositivo");
    lcd.locate(0,2);
    lcd.printf("mide el ritmo "); 
    lcd.locate(0,3);
    lcd.printf("cardiaco.");wait(4);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Por favor, mantenga");
    lcd.locate(0,1);
    lcd.printf("presionada la tecla");
    lcd.locate(0,2);
    lcd.printf("Por 3 Seg,segun su ");
    lcd.locate(0,3);
    lcd.printf("Eleccion ");wait(4);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("0 Para Salir");
    lcd.locate(0,1); 
    lcd.printf("1 Para Inicio");
    lcd.locate(0,2); 
    lcd.printf("2 Para Ingresar al ECG");wait(3);
    lcd.cls();wait(3);
    teclado();

while(1)
 {   //Lazo principal si se presiona la tecla '2' Entra al programa para medir el ritmo cardiaco 
     if(key=='2')
    {
 WelcomToECG();
 teclado();
 if(key=='A')  lcd.printf("Detectando Senal cardiaca");wait(3);
     lcd.cls();   
    
 for(int i=0;relog.read()<=60;i++)//Incializacion del timer para que empiece en 0 seg y termine en 60seg/1minuto 
{          
  if(i==0)//nos aseguramos que este en 0seg
  relog.start();  //empieza a contar 
  if(Digital==1||Digital1==1)//Condicion de entradas digitales "las entradas estan sicronizadas y son complementarias, es decir si una es 1 la otra es 0"
  j++;//Cuenta los pulsos e incrementa en un minuto, segun los pulso que hayan recibido las entradas digitales
  }
    lcd.cls();
   lcd.locate(0,0);
   lcd.printf("tiempo:%f",relog.read());wait(4);//muestra el tiempo que tardo en ejecutarse en segundos
   lcd.cls();
   lcd.locate(0,0);
   lcd.printf("Ritmo Cardiaco:%d",j);//Muestra cuantos 1 logicos detecto en un minuto, equivalente a los ritmos cardiacos
   lcd.locate(0,1);
   lcd.printf("Latidos/minuto");    
}
    
    
    
    
    else if(key=='0')//Si la variable key='0' sale del programa 
     {  
        lcd.locate(0,1); 
        lcd.printf("Hasta Luego");
        lcd.locate(0,2); 
        lcd.printf("Un gusto servirle :)"); 
         wait(3);
        lcd.cls();
       
        exit(-1);
         }
    else if(key=='1')
    {             //Si la variable key='1' redirecciona el programa a la parte de codigo denominada "Inicio"
    lcd.cls();
    lcd.cls();
    goto Inicio;
    }

    key=NULL; //Se borra el contenido de la variable key para no ocacionar problemas posteriores
}   
    //Fin del programa
}
/* END main */
/*
____________________________
|
|  Funciones Prototipo
|___________________________
*/


uint16_t Letra(uint8_t L);
void barrido(void);
void teclado(void);
void WelcomToECG(void);






