/* ###########################################################################
**    Archivo        : proyecto.c
**    Proyecto       : FRDM-KL46Z_Plantilla
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha          : 31-05-19
**    Descripción    :
**         Este proyecto hace...
**         Al ingresar el codigo correcto abre la activa el motor abriendo la puerta
**   Componentes     : Servo motor, teclado numerico, tarjeta bduino.
**   Configuraciones : 
**   Autores         :
**         ATEAM Development Group:
**          - Trujillo Fern'andez Yosef David
**
**   Versión        : 
**   Revisión       : 
**   Release        : 
**   Bugs & Fixes   :
**   Date           : 
**                    
**                
**
* ###########################################################################/
*/
#include "mbed.h"
#include <Servo.h>
#include<string>
DigitalOut  buzzer (PTA5);
DigitalOut gpo(D0);
DigitalOut led(LED_RED);
DigitalIn sensor (PTC16);
Servo servo (PTA13);
DigitalOut verde (PTE3);
DigitalOut azul (PTE2);



void open (){
    /*for (int i=0; i<50; i++){
        servo=1;
        wait_us(2300);
        servo=0;
        wait_ms(18);
        }*/
        servo=1;
        verde=1;
        azul=0;
    //wait(5);
    
    }
    
    
    
void close (){
    /*for (int i=0; i<50; i++){
        servo=1;
        wait_us(700);
        servo=0;
        wait_ms(20);
        }*/
        verde=0;
        azul=1;
   // wait(5);
    
    }
    
    
using namespace std;
const int numeros[]={0x81,0xE7,0x49,0x43,0x27,0x13,0x11,0xC7,0x01,0x03,0xFF};
const int letras[]={0x05,0x31,0x99,0x61,0x19,0x1D,0x03,0x25,0xE7,0xC3,0xE7,0xB9,0x85,0x85,0x81,0x0D,0x07,0x7D,0x13,0x39,0xA1,0xA1,0xA1,0x25,0x27,0x49};
char const kpdLayout[4][4] = {{'1' ,'2' ,'3' ,'A'},  //row0
                              {'4' ,'5' ,'6' ,'B'},  //row1
                              {'7' ,'8' ,'9' ,'C'},  //row2
                              {'*' ,'0' ,'#' ,'D'}}; //row3

const int contrasena [4]= {1,0,1,0};

struct matriz 
{
    int anterior, actual, estado;
    char caracter;
};// end estruct
class BusDisplay
{
    protected:
    int dig;
    DigitalOut *_pin[8], *_control[4]; 
    matriz **_matriz;
    DigitalIn *_keypad[4]; 
    public:
    BusDisplay(PinName p0 = NC, PinName p1 = NC, PinName p2 = NC, PinName p3 = NC, PinName p4 = NC, PinName p5 = NC, PinName p6 = NC, PinName p7 = NC,PinName p8= NC, PinName p9 = NC, PinName p10 = NC, PinName p11 = NC, PinName p12= NC, PinName p13= NC, PinName p14= NC, PinName p15= NC );
    void write(int value);
    void write_text(BusDisplay &cadena, string text );
    void write_value(BusDisplay &cadena, int  entrada[]);
    void read ( BusDisplay &cadena, int &a); 
    
    
    virtual ~BusDisplay();       
    };//class Busdisplay    
BusDisplay::BusDisplay(PinName p0, PinName p1, PinName p2, PinName p3, PinName p4, PinName p5, PinName p6, PinName p7,PinName p8, PinName p9, PinName p10, PinName p11, PinName p12, PinName p13, PinName p14, PinName p15)
{ 
    PinName pins[8] = {p0, p1, p2, p3, p4, p5, p6, p7};
    PinName control[4]= {p8, p9, p10, p11};

    for (int i=0; i<8; i++) 
    {
        _pin[i] = (pins[i] != NC) ? new DigitalOut(pins[i]) : 0;
        //_pin[i]->write(0);
    }
    for (int i=0; i<4; i++) 
    {
        _control[i] = (control[i] != NC) ? new DigitalOut(control[i]) : 0;
        //_control[i]->write(0);
    }
    dig=4;
    PinName keypad[4]= {p12, p13, p14, p15};
    for (int i=0; i<4; i++) 
    {
        _keypad[i] = (keypad[i] != NC) ? new DigitalIn(keypad[i], PullUp) : 0;
       
    }
    _matriz= new matriz *[4];
    for(int i=0; i<4; i++) 
    {
        _matriz[i]= new matriz [4];
    }
    for (int i=0; i<4; i++) 
    {
        for (int j=0; j<4; j++) 
        {
            (*(_matriz+i)+j)->estado=3;
            (*(_matriz+i)+j)->anterior=0;
            (*(_matriz+i)+j)->actual=0;
            (*(_matriz+i)+j)->caracter= kpdLayout[i][j]; 
        }
    }  
 
    
      
}    //BusDisplay

void BusDisplay::write_text(BusDisplay &cadena, string text )
{
    int i=0 ;  
     while(text[i]!='\0') {
         cadena.write(letras[(((int)text[i])-65)]);
         i++;
     }//end while
     
 }//write_text
void BusDisplay::write_value(BusDisplay &cadena, int  entrada[])
{
    /*int millares=numero/1000;
    int centenas=(numero-(millares*1000))/100;
    int decenas=(numero- (millares*1000 + centenas*100))/10;
    int unidades=numero-(millares*1000 + centenas*100 + decenas*10 );*/
    
    cadena.write(numeros[entrada[0]]);
    cadena.write(numeros[entrada[1]]);
    cadena.write(numeros[entrada[2]]);
    cadena.write(numeros[entrada[3]]);
}//write_value




void BusDisplay::write(int value)
{    
    
     if(dig==4) {

        for (int i=0; i<8; i++) {
            if (_pin[i] != 0) {
                
                _pin[i]->write((value >> i) & 1);
            }
        }
        _control[0]->write(1);
        for(int j=0; j<4;j++){
            (*(_matriz+0)+j)->actual=! (_keypad[j]->read());
        //     wait_ms(5);      
            }
        _control[1]->write(0);
        _control[2]->write(0);
        _control[3]->write(0);
        wait_ms(5);
    }//endif(digi==4)
    else if(dig==3) {
        for (int i=0; i<8; i++) {
            if (_pin[i] != 0) {
                _pin[i]->write((value >> i) & 1);
            }
        }
        _control[0]->write(0);
        _control[1]->write(1);
         for(int j=0; j<4;j++){
            (*(_matriz+1)+j)->actual=!(_keypad[j]->read());
          //   wait_ms(5);      
            }
        _control[2]->write(0);
        _control[3]->write(0);
        wait_ms(5);


    }//endif(digi==3)
    else if(dig==2) {

        for (int i=0; i<8; i++) {
            if (_pin[i] != 0) {
                _pin[i]->write((value >> i) & 1);
            }
        }
        _control[0]->write(0);
        _control[1]->write(0);
        _control[2]->write(1);
         for(int j=0; j<4;j++){
            (*(_matriz+2)+j)->actual=!(_keypad[j]->read());
            // wait_ms(5);      
            }
        _control[3]->write(0);
        wait_ms(5);

    }//endif(digi==2)
    else if(dig==1) {

        for (int i=0; i<8; i++) {
            if (_pin[i] != 0) {
                _pin[i]->write((value >> i) & 1);
            }
        }
        _control[0]->write(0);
        _control[1]->write(0);
        _control[2]->write(0);
        _control[3]->write(1);
         for(int j=0; j<4;j++){
            (*(_matriz+3)+j)->actual=!(_keypad[j]->read());
             //  wait_ms(5);    
            }
        wait_ms(5);
        dig=5;

    }//endif(digi==1)
    dig--;


}
void BusDisplay::read( BusDisplay &cadena, int & a){
 
  for(int i=0; i<4; i++){
      for(int j=0;j<4;j++){
          if((*(_matriz+i)+j)->actual==1){
          a= (int)(((*(_matriz+i)+j)->caracter) - 48);
          
          }
          }//for j 
      } //for i
  
    } // end read()
BusDisplay::~BusDisplay()
{
    for (int i=0; i<8; i++) {
        delete _pin[i];

    }
    for(int i=0; i<4; i++) {
        delete _control[i];

    }
}//~BusDisplay


BusDisplay bus(PTE16,PTE17,PTE18,PTE19,PTE20,PTE21,PTE22,PTE23,PTA14,PTA15,PTA16,PTA17,      PTC11,PTC10,PTC9,PTC8);
int main(){
   
  
  bus.write_text(bus, "CLOSE");
  
      
     verde=0;
     azul=1;
     
    while (true) {
        if(sensor.read()==0)
        {open();
         bus.write_text(bus, "OPEN");              
            }
         
         else
         {bus.write_text(bus, "CLOSE");
         close();
        }   
    }
}